/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db.nosql.mongo;

import cn.hutool.core.exceptions.NotInitedException;
import cn.hutool.core.net.NetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.db.DbRuntimeException;
import cn.hutool.log.Log;
import cn.hutool.setting.Setting;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.io.Closeable;
import java.util.ArrayList;
import org.bson.Document;

public class MongoDS
implements Closeable {
    private static final Log log = Log.get();
    public static final String MONGO_CONFIG_PATH = "config/mongo.setting";
    private Setting setting;
    private String[] groups;
    private ServerAddress serverAddress;
    private MongoClient mongo;

    public MongoDS(String host, int port) {
        this.serverAddress = this.createServerAddress(host, port);
        this.initSingle();
    }

    public MongoDS(Setting mongoSetting, String host, int port) {
        this.setting = mongoSetting;
        this.serverAddress = this.createServerAddress(host, port);
        this.initSingle();
    }

    public MongoDS(String ... groups) {
        this.groups = groups;
        this.init();
    }

    public MongoDS(Setting mongoSetting, String ... groups) {
        if (mongoSetting == null) {
            throw new DbRuntimeException("Mongo setting is null!");
        }
        this.setting = mongoSetting;
        this.groups = groups;
        this.init();
    }

    public void init() {
        if (this.groups != null && this.groups.length > 1) {
            this.initCloud();
        } else {
            this.initSingle();
        }
    }

    public synchronized void initSingle() {
        if (this.setting == null) {
            try {
                this.setting = new Setting(MONGO_CONFIG_PATH, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String group = "";
        if (null == this.serverAddress) {
            if (this.groups != null && this.groups.length == 1) {
                group = this.groups[0];
            }
            this.serverAddress = this.createServerAddress(group);
        }
        MongoCredential credentail = this.createCredentail(group);
        try {
            this.mongo = null == credentail ? new MongoClient(this.serverAddress, this.buildMongoClientOptions(group)) : new MongoClient(this.serverAddress, credentail, this.buildMongoClientOptions(group));
        }
        catch (Exception e) {
            throw new DbRuntimeException(StrUtil.format((CharSequence)"Init MongoDB pool with connection to [{}] error!", (Object[])new Object[]{this.serverAddress}), e);
        }
        log.info("Init MongoDB pool with connection to [{}]", new Object[]{this.serverAddress});
    }

    public synchronized void initCloud() {
        if (this.groups == null || this.groups.length == 0) {
            throw new DbRuntimeException("Please give replication set groups!");
        }
        if (this.setting == null) {
            this.setting = new Setting(MONGO_CONFIG_PATH, true);
        }
        ArrayList<ServerAddress> addrList = new ArrayList<ServerAddress>();
        for (String group : this.groups) {
            addrList.add(this.createServerAddress(group));
        }
        MongoCredential credentail = this.createCredentail("");
        try {
            this.mongo = null == credentail ? new MongoClient(addrList, this.buildMongoClientOptions("")) : new MongoClient(addrList, credentail, this.buildMongoClientOptions(""));
        }
        catch (Exception e) {
            log.error((Throwable)e, "Init MongoDB connection error!", new Object[0]);
            return;
        }
        log.info("Init MongoDB cloud Set pool with connection to {}", new Object[]{addrList});
    }

    public void setSetting(Setting setting) {
        this.setting = setting;
    }

    public MongoClient getMongo() {
        return this.mongo;
    }

    public MongoDatabase getDb(String dbName) {
        return this.mongo.getDatabase(dbName);
    }

    public MongoCollection<Document> getCollection(String dbName, String collectionName) {
        return this.getDb(dbName).getCollection(collectionName);
    }

    @Override
    public void close() {
        this.mongo.close();
    }

    private ServerAddress createServerAddress(String group) {
        String tmpHost;
        Setting setting = this.checkSetting();
        if (group == null) {
            group = "";
        }
        if (StrUtil.isBlank((CharSequence)(tmpHost = setting.getByGroup("host", group)))) {
            throw new NotInitedException("Host name is empy of group: {}", new Object[]{group});
        }
        int defaultPort = setting.getInt("port", group, Integer.valueOf(27017));
        return new ServerAddress(NetUtil.buildInetSocketAddress((String)tmpHost, (int)defaultPort));
    }

    private ServerAddress createServerAddress(String host, int port) {
        return new ServerAddress(host, port);
    }

    private MongoCredential createCredentail(String group) {
        Setting setting = this.setting;
        if (null == setting) {
            return null;
        }
        String user = setting.getStr("user", group, setting.getStr((Object)"user"));
        String pass = setting.getStr("pass", group, setting.getStr((Object)"pass"));
        String database = setting.getStr("database", group, setting.getStr((Object)"database"));
        return this.createCredentail(user, database, pass);
    }

    private MongoCredential createCredentail(String userName, String database, String password) {
        if (StrUtil.hasEmpty((CharSequence[])new CharSequence[]{userName, database, database})) {
            return null;
        }
        return MongoCredential.createCredential((String)userName, (String)database, (char[])password.toCharArray());
    }

    private MongoClientOptions buildMongoClientOptions(String group) {
        return this.buildMongoClientOptions(MongoClientOptions.builder(), group).build();
    }

    private MongoClientOptions.Builder buildMongoClientOptions(MongoClientOptions.Builder builder, String group) {
        if (this.setting == null) {
            return builder;
        }
        group = StrUtil.isEmpty((CharSequence)group) ? "" : group + ".";
        Integer connectionsPerHost = this.setting.getInt((Object)(group + "connectionsPerHost"));
        if (!StrUtil.isBlank((CharSequence)group) && connectionsPerHost == null) {
            connectionsPerHost = this.setting.getInt((Object)"connectionsPerHost");
        }
        if (connectionsPerHost != null) {
            builder.connectionsPerHost(connectionsPerHost.intValue());
            log.debug("MongoDB connectionsPerHost: {}", new Object[]{connectionsPerHost});
        }
        Integer connectTimeout = this.setting.getInt((Object)(group + "connectTimeout"));
        if (!StrUtil.isBlank((CharSequence)group) && connectTimeout == null) {
            this.setting.getInt((Object)"connectTimeout");
        }
        if (connectTimeout != null) {
            builder.connectTimeout(connectTimeout.intValue());
            log.debug("MongoDB connectTimeout: {}", new Object[]{connectTimeout});
        }
        Integer socketTimeout = this.setting.getInt((Object)(group + "socketTimeout"));
        if (!StrUtil.isBlank((CharSequence)group) && socketTimeout == null) {
            this.setting.getInt((Object)"socketTimeout");
        }
        if (socketTimeout != null) {
            builder.socketTimeout(socketTimeout.intValue());
            log.debug("MongoDB socketTimeout: {}", new Object[]{socketTimeout});
        }
        return builder;
    }

    private Setting checkSetting() {
        if (null == this.setting) {
            throw new DbRuntimeException("Please indicate setting file or create default [{}]", MONGO_CONFIG_PATH);
        }
        return this.setting;
    }
}

