/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.ssh;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.lang.Filter;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.ftp.AbstractFtp;
import cn.hutool.extra.ftp.FtpConfig;
import cn.hutool.extra.ftp.FtpException;
import cn.hutool.extra.ssh.JschRuntimeException;
import cn.hutool.extra.ssh.JschUtil;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import java.io.File;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class Sftp
extends AbstractFtp {
    private Session session;
    private ChannelSftp channel;

    public Sftp(String sshHost, int sshPort, String sshUser, String sshPass) {
        this(sshHost, sshPort, sshUser, sshPass, DEFAULT_CHARSET);
    }

    public Sftp(String sshHost, int sshPort, String sshUser, String sshPass, Charset charset) {
        this(new FtpConfig(sshHost, sshPort, sshUser, sshPass, charset));
    }

    public Sftp(FtpConfig config) {
        super(config);
        this.init(config);
    }

    public Sftp(Session session) {
        this(session, DEFAULT_CHARSET);
    }

    public Sftp(Session session, Charset charset) {
        super(FtpConfig.create().setCharset(charset));
        this.init(session, charset);
    }

    public Sftp(ChannelSftp channel, Charset charset) {
        super(FtpConfig.create().setCharset(charset));
        this.init(channel, charset);
    }

    public void init(String sshHost, int sshPort, String sshUser, String sshPass, Charset charset) {
        this.init(JschUtil.getSession(sshHost, sshPort, sshUser, sshPass), charset);
    }

    public void init() {
        this.init(this.ftpConfig);
    }

    public void init(FtpConfig config) {
        this.init(config.getHost(), config.getPort(), config.getUser(), config.getPassword(), config.getCharset());
    }

    public void init(Session session, Charset charset) {
        this.session = session;
        this.init(JschUtil.openSftp(session, (int)this.ftpConfig.getConnectionTimeout()), charset);
    }

    public void init(ChannelSftp channel, Charset charset) {
        this.ftpConfig.setCharset(charset);
        try {
            channel.setFilenameEncoding(charset.toString());
        }
        catch (SftpException e) {
            throw new JschRuntimeException(e);
        }
        this.channel = channel;
    }

    @Override
    public Sftp reconnectIfTimeout() {
        if (StrUtil.isBlank((CharSequence)this.ftpConfig.getHost())) {
            throw new FtpException("Host is blank!");
        }
        try {
            this.cd("/");
        }
        catch (FtpException e) {
            this.close();
            this.init();
        }
        return this;
    }

    public ChannelSftp getClient() {
        return this.channel;
    }

    @Override
    public String pwd() {
        try {
            return this.channel.pwd();
        }
        catch (SftpException e) {
            throw new JschRuntimeException(e);
        }
    }

    public String home() {
        try {
            return this.channel.getHome();
        }
        catch (SftpException e) {
            throw new JschRuntimeException(e);
        }
    }

    @Override
    public List<String> ls(String path) {
        return this.ls(path, null);
    }

    public List<String> lsDirs(String path) {
        return this.ls(path, (Filter<ChannelSftp.LsEntry>)((Filter)t -> t.getAttrs().isDir()));
    }

    public List<String> lsFiles(String path) {
        return this.ls(path, (Filter<ChannelSftp.LsEntry>)((Filter)t -> false == t.getAttrs().isDir()));
    }

    public List<String> ls(String path, Filter<ChannelSftp.LsEntry> filter) {
        List<ChannelSftp.LsEntry> entries = this.lsEntries(path, filter);
        if (CollUtil.isEmpty(entries)) {
            return ListUtil.empty();
        }
        return CollUtil.map(entries, ChannelSftp.LsEntry::getFilename, (boolean)true);
    }

    public List<ChannelSftp.LsEntry> lsEntries(String path) {
        return this.lsEntries(path, null);
    }

    public List<ChannelSftp.LsEntry> lsEntries(String path, Filter<ChannelSftp.LsEntry> filter) {
        ArrayList<ChannelSftp.LsEntry> entryList;
        block2: {
            entryList = new ArrayList<ChannelSftp.LsEntry>();
            try {
                this.channel.ls(path, entry -> {
                    String fileName = entry.getFilename();
                    if (!(StrUtil.equals((CharSequence)".", (CharSequence)fileName) || StrUtil.equals((CharSequence)"..", (CharSequence)fileName) || null != filter && !filter.accept((Object)entry))) {
                        entryList.add(entry);
                    }
                    return 0;
                });
            }
            catch (SftpException e) {
                if (StrUtil.startWithIgnoreCase((CharSequence)e.getMessage(), (CharSequence)"No such file")) break block2;
                throw new JschRuntimeException(e);
            }
        }
        return entryList;
    }

    @Override
    public boolean mkdir(String dir) {
        if (this.isDir(dir)) {
            return true;
        }
        try {
            this.channel.mkdir(dir);
            return true;
        }
        catch (SftpException e) {
            throw new JschRuntimeException(e);
        }
    }

    @Override
    public boolean isDir(String dir) {
        SftpATTRS sftpATTRS;
        try {
            sftpATTRS = this.channel.stat(dir);
        }
        catch (SftpException e) {
            if (e.getMessage().contains("No such file")) {
                return false;
            }
            throw new FtpException(e);
        }
        return sftpATTRS.isDir();
    }

    @Override
    public synchronized boolean cd(String directory) throws FtpException {
        if (StrUtil.isBlank((CharSequence)directory)) {
            return true;
        }
        try {
            this.channel.cd(directory.replace('\\', '/'));
            return true;
        }
        catch (SftpException e) {
            throw new FtpException(e);
        }
    }

    @Override
    public boolean delFile(String filePath) {
        try {
            this.channel.rm(filePath);
        }
        catch (SftpException e) {
            throw new JschRuntimeException(e);
        }
        return true;
    }

    @Override
    public boolean delDir(String dirPath) {
        Vector list;
        if (!this.cd(dirPath)) {
            return false;
        }
        try {
            list = this.channel.ls(this.channel.pwd());
        }
        catch (SftpException e) {
            throw new JschRuntimeException(e);
        }
        for (ChannelSftp.LsEntry entry : list) {
            String fileName = entry.getFilename();
            if (".".equals(fileName) || "..".equals(fileName)) continue;
            if (entry.getAttrs().isDir()) {
                this.delDir(fileName);
                continue;
            }
            this.delFile(fileName);
        }
        if (!this.cd("..")) {
            return false;
        }
        try {
            this.channel.rmdir(dirPath);
            return true;
        }
        catch (SftpException e) {
            throw new JschRuntimeException(e);
        }
    }

    public void syncUpload(File file, String remotePath) {
        if (!FileUtil.exist((File)file)) {
            return;
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files == null) {
                return;
            }
            for (File fileItem : files) {
                if (fileItem.isDirectory()) {
                    String mkdir = FileUtil.normalize((String)(remotePath + "/" + fileItem.getName()));
                    this.syncUpload(fileItem, mkdir);
                    continue;
                }
                this.syncUpload(fileItem, remotePath);
            }
        } else {
            this.mkDirs(remotePath);
            this.upload(remotePath, file);
        }
    }

    @Override
    public boolean upload(String destPath, File file) {
        this.put(FileUtil.getAbsolutePath((File)file), destPath);
        return true;
    }

    public Sftp put(String srcFilePath, String destPath) {
        return this.put(srcFilePath, destPath, Mode.OVERWRITE);
    }

    public Sftp put(String srcFilePath, String destPath, Mode mode) {
        return this.put(srcFilePath, destPath, null, mode);
    }

    public Sftp put(String srcFilePath, String destPath, SftpProgressMonitor monitor, Mode mode) {
        try {
            this.channel.put(srcFilePath, destPath, monitor, mode.ordinal());
        }
        catch (SftpException e) {
            throw new JschRuntimeException(e);
        }
        return this;
    }

    @Override
    public void download(String src, File destFile) {
        this.get(src, FileUtil.getAbsolutePath((File)destFile));
    }

    public void download(String src, OutputStream out) {
        this.get(src, out);
    }

    @Override
    public void recursiveDownloadFolder(String sourcePath, File destDir) throws JschRuntimeException {
        for (ChannelSftp.LsEntry item : this.lsEntries(sourcePath)) {
            String fileName = item.getFilename();
            String srcFile = StrUtil.format((CharSequence)"{}/{}", (Object[])new Object[]{sourcePath, fileName});
            File destFile = FileUtil.file((File)destDir, (String)fileName);
            if (!item.getAttrs().isDir()) {
                if (FileUtil.exist((File)destFile) && (long)item.getAttrs().getMTime() <= destFile.lastModified() / 1000L) continue;
                this.download(srcFile, destFile);
                continue;
            }
            FileUtil.mkdir((File)destFile);
            this.recursiveDownloadFolder(srcFile, destFile);
        }
    }

    public Sftp get(String src, String dest) {
        try {
            this.channel.get(src, dest);
        }
        catch (SftpException e) {
            throw new JschRuntimeException(e);
        }
        return this;
    }

    public Sftp get(String src, OutputStream out) {
        try {
            this.channel.get(src, out);
        }
        catch (SftpException e) {
            throw new JschRuntimeException(e);
        }
        return this;
    }

    @Override
    public void close() {
        JschUtil.close((Channel)this.channel);
        JschUtil.close(this.session);
    }

    public String toString() {
        return "Sftp{host='" + this.ftpConfig.getHost() + '\'' + ", port=" + this.ftpConfig.getPort() + ", user='" + this.ftpConfig.getUser() + '\'' + '}';
    }

    public static enum Mode {
        OVERWRITE,
        RESUME,
        APPEND;

    }
}

