/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.command.handler;

import com.alibaba.csp.sentinel.command.CommandHandler;
import com.alibaba.csp.sentinel.command.CommandRequest;
import com.alibaba.csp.sentinel.command.CommandResponse;
import com.alibaba.csp.sentinel.command.annotation.CommandMapping;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowSlot;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParameterMetric;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.fastjson.JSON;
import java.util.Map;

@CommandMapping(name="topParams")
public class FetchTopParamsCommandHandler
implements CommandHandler<String> {
    public CommandResponse<String> handle(CommandRequest request) {
        int amount;
        int index;
        String resourceName = request.getParam("res");
        if (StringUtil.isBlank((String)resourceName)) {
            return CommandResponse.ofFailure((Throwable)new IllegalArgumentException("Invalid parameter: res"));
        }
        String idx = request.getParam("idx");
        try {
            index = Integer.valueOf(idx);
        }
        catch (Exception ex) {
            return CommandResponse.ofFailure((Throwable)ex, (Object)"Invalid parameter: idx");
        }
        String n = request.getParam("n");
        try {
            amount = Integer.valueOf(n);
        }
        catch (Exception ex) {
            return CommandResponse.ofFailure((Throwable)ex, (Object)"Invalid parameter: n");
        }
        ParameterMetric metric = ParamFlowSlot.getHotParamMetricForName(resourceName);
        if (metric == null) {
            return CommandResponse.ofSuccess((Object)"{}");
        }
        Map<Object, Double> values = metric.getTopPassParamCount(index, amount);
        return CommandResponse.ofSuccess((Object)JSON.toJSONString(values));
    }
}

