/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONPath;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderImplMapString;
import com.alibaba.fastjson2.reader.ObjectReaderImplMapTyped;
import com.alibaba.fastjson2.util.Fastjson1xSupport;
import com.alibaba.fastjson2.util.GuavaSupport;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.JSONObject1O;
import com.alibaba.fastjson2.util.ReferenceKey;
import com.alibaba.fastjson2.util.TypeUtils;
import com.alibaba.fastjson2.util.UnsafeUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.Function;
import java.util.function.Supplier;

public final class ObjectReaderImplMap
implements ObjectReader {
    static final Class CLASS_SINGLETON_MAP = Collections.singletonMap(1, 1).getClass();
    static final Class CLASS_EMPTY_MAP = Collections.EMPTY_MAP.getClass();
    static final Class CLASS_EMPTY_SORTED_MAP = Collections.emptySortedMap().getClass();
    static final Class CLASS_EMPTY_NAVIGABLE_MAP = Collections.emptyNavigableMap().getClass();
    static final Class CLASS_UNMODIFIABLE_MAP = Collections.unmodifiableMap(Collections.emptyMap()).getClass();
    static final Class CLASS_UNMODIFIABLE_SORTED_MAP = Collections.unmodifiableSortedMap(Collections.emptySortedMap()).getClass();
    static final Class CLASS_UNMODIFIABLE_NAVIGABLE_MAP = Collections.unmodifiableNavigableMap(Collections.emptyNavigableMap()).getClass();
    public static ObjectReaderImplMap INSTANCE = new ObjectReaderImplMap(null, HashMap.class, HashMap.class, 0L, null);
    public static ObjectReaderImplMap INSTANCE_OBJECT = new ObjectReaderImplMap(null, JSONObject.class, JSONObject.class, 0L, null);
    final Type fieldType;
    final Class mapType;
    final Class instanceType;
    final long features;
    final Function builder;
    volatile boolean instanceError;

    public static ObjectReader of(Type fieldType, Class mapType, long features) {
        String instanceTypeName;
        ParameterizedType parameterizedType;
        Type[] actualTypeArguments;
        Function builder = null;
        Class instanceType = mapType;
        if (mapType == Map.class || mapType == AbstractMap.class || mapType == CLASS_SINGLETON_MAP) {
            instanceType = HashMap.class;
        } else if (mapType == CLASS_UNMODIFIABLE_MAP) {
            instanceType = LinkedHashMap.class;
        } else if (mapType == SortedMap.class || mapType == CLASS_UNMODIFIABLE_SORTED_MAP || mapType == CLASS_UNMODIFIABLE_NAVIGABLE_MAP) {
            instanceType = TreeMap.class;
        } else if (mapType == ConcurrentMap.class) {
            instanceType = ConcurrentHashMap.class;
        } else if (mapType == ConcurrentNavigableMap.class) {
            instanceType = ConcurrentSkipListMap.class;
        } else {
            switch (mapType.getTypeName()) {
                case "com.google.common.collect.ImmutableMap": 
                case "com.google.common.collect.RegularImmutableMap": {
                    instanceType = HashMap.class;
                    builder = GuavaSupport.immutableMapConverter();
                    break;
                }
                case "com.google.common.collect.SingletonImmutableBiMap": {
                    instanceType = HashMap.class;
                    builder = GuavaSupport.singletonBiMapConverter();
                    break;
                }
            }
        }
        if (fieldType instanceof ParameterizedType && (actualTypeArguments = (parameterizedType = (ParameterizedType)fieldType).getActualTypeArguments()).length == 2 && !"org.springframework.util.LinkedMultiValueMap".equals(instanceType.getName())) {
            Type keyType = actualTypeArguments[0];
            Type valueType = actualTypeArguments[1];
            if (valueType == String.class && builder == null) {
                return new ObjectReaderImplMapString(mapType, instanceType, features);
            }
            return new ObjectReaderImplMapTyped(mapType, instanceType, keyType, valueType, 0L, builder);
        }
        if (fieldType == null && features == 0L) {
            if (mapType == HashMap.class && instanceType == HashMap.class) {
                return INSTANCE;
            }
            if (mapType == JSONObject.class && instanceType == JSONObject.class) {
                return INSTANCE_OBJECT;
            }
        }
        switch (instanceTypeName = instanceType.getName()) {
            case "com.alibaba.fastjson.JSONObject": {
                builder = Fastjson1xSupport.createObjectSupplier(instanceType);
                instanceType = HashMap.class;
                break;
            }
            case "com.google.common.collect.RegularImmutableMap": {
                builder = GuavaSupport.immutableMapConverter();
                instanceType = HashMap.class;
                break;
            }
            case "com.google.common.collect.SingletonImmutableBiMap": {
                builder = GuavaSupport.singletonBiMapConverter();
                instanceType = HashMap.class;
                break;
            }
            case "com.google.common.collect.ArrayListMultimap": {
                builder = GuavaSupport.createConvertFunction(instanceType);
                instanceType = HashMap.class;
                break;
            }
            default: {
                if (instanceType == JSONObject1O.class) {
                    Class objectClass = TypeUtils.loadClass("com.alibaba.fastjson.JSONObject");
                    builder = Fastjson1xSupport.createObjectSupplier(objectClass);
                    instanceType = LinkedHashMap.class;
                    break;
                }
                if (mapType == CLASS_UNMODIFIABLE_MAP) {
                    builder = Collections::unmodifiableMap;
                    break;
                }
                if (mapType == CLASS_UNMODIFIABLE_SORTED_MAP) {
                    builder = Collections::unmodifiableSortedMap;
                    break;
                }
                if (mapType == CLASS_UNMODIFIABLE_NAVIGABLE_MAP) {
                    builder = Collections::unmodifiableNavigableMap;
                    break;
                }
                if (mapType != CLASS_SINGLETON_MAP) break;
                builder = map -> {
                    Map.Entry entry = map.entrySet().iterator().next();
                    return Collections.singletonMap(entry.getKey(), entry.getValue());
                };
            }
        }
        return new ObjectReaderImplMap(fieldType, mapType, instanceType, features, builder);
    }

    ObjectReaderImplMap(Type fieldType, Class mapType, Class instanceType, long features, Function builder) {
        this.fieldType = fieldType;
        this.mapType = mapType;
        this.instanceType = instanceType;
        this.features = features;
        this.builder = builder;
    }

    public Class getObjectClass() {
        return this.mapType;
    }

    public Function getBuilder() {
        return this.builder;
    }

    @Override
    public Function getBuildFunction() {
        return this.builder;
    }

    public Object createInstance(long features) {
        if (this.instanceType == HashMap.class) {
            return new HashMap();
        }
        if (this.instanceType == LinkedHashMap.class) {
            return new LinkedHashMap();
        }
        if (this.instanceType == JSONObject.class) {
            return new JSONObject();
        }
        if (this.instanceType == CLASS_EMPTY_MAP) {
            return Collections.emptyMap();
        }
        if (this.instanceType == CLASS_EMPTY_SORTED_MAP) {
            return Collections.emptySortedMap();
        }
        if (this.instanceType == CLASS_EMPTY_NAVIGABLE_MAP) {
            return Collections.emptyNavigableMap();
        }
        if (JDKUtils.UNSAFE_SUPPORT) {
            String instanceTypeName;
            switch (instanceTypeName = this.instanceType.getName()) {
                case "com.ali.com.google.common.collect.EmptyImmutableBiMap": {
                    return ((Supplier<Object>)() -> {
                        try {
                            return UnsafeUtils.UNSAFE.allocateInstance(this.instanceType);
                        }
                        catch (InstantiationException e) {
                            throw new JSONException("create map error : " + this.instanceType);
                        }
                    }).get();
                }
            }
        }
        try {
            return this.instanceType.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new JSONException("create map error : " + this.instanceType);
        }
    }

    public Object createInstance(Map map, long features) {
        if (this.mapType.isInstance(map)) {
            return map;
        }
        return map;
    }

    @Override
    public FieldReader getFieldReader(long hashCode) {
        return null;
    }

    public Object readJSONBObject(JSONReader jsonReader, long features) {
        ObjectReader objectReader = jsonReader.checkAutoType(this.mapType, 0L, this.features | features);
        if (objectReader != null && objectReader != this) {
            return objectReader.readJSONBObject(jsonReader, features);
        }
        boolean emptyObject = false;
        jsonReader.nextIfMatch((byte)-90);
        Supplier<Map> objectSupplier = jsonReader.getContext().getObjectSupplier();
        Map<String, Object> map = null;
        if (this.mapType == null && objectSupplier != null) {
            map = objectSupplier.get();
        } else if (this.instanceType == HashMap.class) {
            map = new HashMap();
        } else if (this.instanceType == LinkedHashMap.class) {
            map = new LinkedHashMap();
        } else if (this.instanceType == JSONObject.class) {
            map = new JSONObject();
        } else if (this.instanceType == CLASS_EMPTY_MAP) {
            map = Collections.EMPTY_MAP;
        } else {
            JSONException error;
            block42: {
                error = null;
                if (!this.instanceError) {
                    try {
                        map = (Map)this.instanceType.newInstance();
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        this.instanceError = true;
                        error = new JSONException("create map error " + this.instanceType);
                    }
                }
                if (this.instanceError && Map.class.isAssignableFrom(this.instanceType.getSuperclass())) {
                    try {
                        map = (Map)this.instanceType.getSuperclass().newInstance();
                        error = null;
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        if (error != null) break block42;
                        error = new JSONException("create map error " + this.instanceType);
                    }
                }
            }
            if (error != null) {
                throw error;
            }
        }
        if (!emptyObject) {
            boolean supportAutoType = jsonReader.isSupportAutoType(features);
            int i = 0;
            while (true) {
                String reference;
                Object fieldName;
                byte type;
                if ((type = jsonReader.getType()) == -91) {
                    jsonReader.next();
                    break;
                }
                if (type >= 73 && type <= 127) {
                    fieldName = jsonReader.readFieldName();
                } else if (jsonReader.nextIfMatch((byte)-109)) {
                    reference = jsonReader.readString();
                    fieldName = new ReferenceKey(i);
                    jsonReader.addResolveTask(map, fieldName, JSONPath.of(reference));
                } else {
                    fieldName = jsonReader.readAny();
                }
                if (jsonReader.isReference()) {
                    reference = jsonReader.readReference();
                    if ("..".equals(reference)) {
                        map.put((String)fieldName, map);
                    } else {
                        jsonReader.addResolveTask(map, fieldName, JSONPath.of(reference));
                        map.put((String)fieldName, null);
                    }
                } else {
                    Map<String, Object> value;
                    type = jsonReader.getType();
                    if (type >= 73 && type <= 125) {
                        value = jsonReader.readString();
                    } else if (type == -110) {
                        ObjectReader autoTypeObjectReader = jsonReader.checkAutoType(Object.class, 0L, this.features | features);
                        value = autoTypeObjectReader.readJSONBObject(jsonReader, features);
                    } else if (type == -79) {
                        value = Boolean.TRUE;
                        jsonReader.next();
                    } else if (type == -80) {
                        value = Boolean.FALSE;
                        jsonReader.next();
                    } else if (type == -109) {
                        String reference2 = jsonReader.readReference();
                        if ("..".equals(reference2)) {
                            value = map;
                        } else {
                            value = null;
                            jsonReader.addResolveTask(map, fieldName, JSONPath.of(reference2));
                        }
                    } else {
                        value = jsonReader.readAny();
                    }
                    map.put((String)fieldName, value);
                }
                ++i;
            }
        }
        if (this.builder != null) {
            return this.builder.apply(map);
        }
        return map;
    }

    public Object readObject(JSONReader jsonReader, long features) {
        JSONReader.Context context = jsonReader.getContext();
        Supplier<Map> objectSupplier = jsonReader.getContext().getObjectSupplier();
        Map object = (this.mapType == null || this.mapType == JSONObject.class) && objectSupplier != null ? objectSupplier.get() : (Map)this.createInstance(context.getFeatures() | features);
        boolean match = jsonReader.nextIfMatch('{');
        boolean typeRedirect = false;
        if (!match) {
            typeRedirect = jsonReader.isTypeRedirect();
            if (typeRedirect) {
                jsonReader.setTypeRedirect(false);
            } else {
                String str;
                if (jsonReader.isString() && (str = jsonReader.readString()).isEmpty()) {
                    return object;
                }
                throw new JSONException("illegal input\uff0c offset " + jsonReader.getOffset() + ", char " + jsonReader.current());
            }
        }
        block9: while (!jsonReader.nextIfMatch('}')) {
            Object value;
            String name;
            if (match || typeRedirect) {
                name = jsonReader.readFieldName();
            } else {
                name = jsonReader.getFieldName();
                match = true;
            }
            if (name == null) {
                name = jsonReader.readFieldNameUnquote();
                if (jsonReader.current() == ':') {
                    jsonReader.next();
                }
            }
            switch (jsonReader.current()) {
                case '+': 
                case '-': 
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    value = jsonReader.readNumber();
                    break;
                }
                case '[': {
                    value = jsonReader.readArray();
                    break;
                }
                case '{': {
                    value = jsonReader.readObject();
                    break;
                }
                case '\"': 
                case '\'': {
                    value = jsonReader.readString();
                    break;
                }
                case 'f': 
                case 't': {
                    value = jsonReader.readBoolValue();
                    break;
                }
                case 'n': {
                    jsonReader.readNull();
                    value = null;
                    break;
                }
                case '/': {
                    jsonReader.next();
                    char ch = jsonReader.current();
                    if (ch == '/') {
                        jsonReader.skipLineComment();
                        continue block9;
                    }
                    throw new JSONException("input not support " + ch + ", offset " + jsonReader.getOffset());
                }
                default: {
                    throw new JSONException("error, offset " + jsonReader.getOffset() + ", char " + jsonReader.current());
                }
            }
            object.put(name, value);
        }
        jsonReader.nextIfMatch(',');
        if (this.builder != null) {
            return this.builder.apply(object);
        }
        return object;
    }
}

