/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.entity.codec.v1;

import com.alipay.sofa.jraft.entity.EnumOutter;
import com.alipay.sofa.jraft.entity.LogEntry;
import com.alipay.sofa.jraft.entity.LogId;
import com.alipay.sofa.jraft.entity.PeerId;
import com.alipay.sofa.jraft.entity.codec.LogEntryDecoder;
import com.alipay.sofa.jraft.util.AsciiStringUtil;
import com.alipay.sofa.jraft.util.Bits;
import java.nio.ByteBuffer;
import java.util.ArrayList;

@Deprecated
public final class V1Decoder
implements LogEntryDecoder {
    public static final V1Decoder INSTANCE = new V1Decoder();

    private V1Decoder() {
    }

    @Override
    public LogEntry decode(byte[] content) {
        if (content == null || content.length == 0) {
            return null;
        }
        if (content[0] != -72) {
            return null;
        }
        LogEntry log = new LogEntry();
        this.decode(log, content);
        return log;
    }

    public void decode(LogEntry log, byte[] content) {
        int iType = Bits.getInt(content, 1);
        log.setType(EnumOutter.EntryType.forNumber(iType));
        long index = Bits.getLong(content, 5);
        long term = Bits.getLong(content, 13);
        log.setId(new LogId(index, term));
        int peerCount = Bits.getInt(content, 21);
        int pos = 25;
        if (peerCount > 0) {
            ArrayList<PeerId> peers = new ArrayList<PeerId>(peerCount);
            while (peerCount-- > 0) {
                short len = Bits.getShort(content, pos);
                byte[] bs = new byte[len];
                System.arraycopy(content, pos + 2, bs, 0, len);
                pos += 2 + len;
                PeerId peer = new PeerId();
                peer.parse(AsciiStringUtil.unsafeDecode(bs));
                peers.add(peer);
            }
            log.setPeers(peers);
        }
        int oldPeerCount = Bits.getInt(content, pos);
        pos += 4;
        if (oldPeerCount > 0) {
            ArrayList<PeerId> oldPeers = new ArrayList<PeerId>(oldPeerCount);
            while (oldPeerCount-- > 0) {
                short len = Bits.getShort(content, pos);
                byte[] bs = new byte[len];
                System.arraycopy(content, pos + 2, bs, 0, len);
                pos += 2 + len;
                PeerId peer = new PeerId();
                peer.parse(AsciiStringUtil.unsafeDecode(bs));
                oldPeers.add(peer);
            }
            log.setOldPeers(oldPeers);
        }
        if (content.length > pos) {
            int len = content.length - pos;
            ByteBuffer data = ByteBuffer.allocate(len);
            data.put(content, pos, len);
            data.flip();
            log.setData(data);
        }
    }
}

