/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rpc.impl;

import com.alipay.remoting.CustomSerializer;
import com.alipay.remoting.CustomSerializerManager;
import com.alipay.remoting.InvokeContext;
import com.alipay.sofa.jraft.option.RpcOptions;
import com.alipay.sofa.jraft.rpc.ProtobufSerializer;
import com.alipay.sofa.jraft.rpc.RaftRpcFactory;
import com.alipay.sofa.jraft.rpc.RpcClient;
import com.alipay.sofa.jraft.rpc.RpcServer;
import com.alipay.sofa.jraft.rpc.impl.BoltRpcClient;
import com.alipay.sofa.jraft.rpc.impl.BoltRpcServer;
import com.alipay.sofa.jraft.rpc.impl.core.JRaftRpcAddressParser;
import com.alipay.sofa.jraft.util.Endpoint;
import com.alipay.sofa.jraft.util.Requires;
import com.alipay.sofa.jraft.util.SPI;

@SPI
public class BoltRaftRpcFactory
implements RaftRpcFactory {
    @Override
    public void registerProtobufSerializer(String className) {
        CustomSerializerManager.registerCustomSerializer((String)className, (CustomSerializer)ProtobufSerializer.INSTANCE);
    }

    @Override
    public RpcClient createRpcClient(RaftRpcFactory.ConfigHelper<RpcClient> helper) {
        com.alipay.remoting.rpc.RpcClient boltImpl = new com.alipay.remoting.rpc.RpcClient();
        BoltRpcClient rpcClient = new BoltRpcClient(boltImpl);
        if (helper != null) {
            helper.config(rpcClient);
        }
        return rpcClient;
    }

    @Override
    public RpcServer createRpcServer(Endpoint endpoint, RaftRpcFactory.ConfigHelper<RpcServer> helper) {
        int port = Requires.requireNonNull(endpoint, "endpoint").getPort();
        Requires.requireTrue(port > 0 && port < 65535, "port out of range:" + port);
        com.alipay.remoting.rpc.RpcServer boltImpl = new com.alipay.remoting.rpc.RpcServer(port, true, false);
        BoltRpcServer rpcServer = new BoltRpcServer(boltImpl);
        if (helper != null) {
            helper.config(rpcServer);
        }
        return rpcServer;
    }

    @Override
    public RaftRpcFactory.ConfigHelper<RpcClient> defaultJRaftClientConfigHelper(RpcOptions opts) {
        return instance -> {
            BoltRpcClient client = (BoltRpcClient)instance;
            InvokeContext ctx = new InvokeContext();
            ctx.put("bolt.invoke.crc.switch", (Object)opts.isEnableRpcChecksum());
            client.setDefaultInvokeCtx(ctx);
            client.setDefaultAddressParser(new JRaftRpcAddressParser());
        };
    }
}

