/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rpc.impl.cli;

import com.alipay.sofa.jraft.entity.PeerId;
import com.alipay.sofa.jraft.error.RaftError;
import com.alipay.sofa.jraft.rpc.CliRequests;
import com.alipay.sofa.jraft.rpc.RpcRequestClosure;
import com.alipay.sofa.jraft.rpc.RpcResponseFactory;
import com.alipay.sofa.jraft.rpc.impl.cli.BaseCliRequestProcessor;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;

public class AddLearnersRequestProcessor
extends BaseCliRequestProcessor<CliRequests.AddLearnersRequest> {
    public AddLearnersRequestProcessor(Executor executor) {
        super(executor);
    }

    @Override
    protected String getPeerId(CliRequests.AddLearnersRequest request) {
        return request.getLeaderId();
    }

    @Override
    protected String getGroupId(CliRequests.AddLearnersRequest request) {
        return request.getGroupId();
    }

    @Override
    protected Message processRequest0(BaseCliRequestProcessor.CliRequestContext ctx, CliRequests.AddLearnersRequest request, RpcRequestClosure done) {
        List<PeerId> oldLearners = ctx.node.listLearners();
        ArrayList<PeerId> addingLearners = new ArrayList<PeerId>(request.getLearnersCount());
        Iterator iterator = request.getLearnersList().iterator();
        while (iterator.hasNext()) {
            PeerId peer = new PeerId();
            String peerStr = (String)iterator.next();
            if (!peer.parse(peerStr)) {
                return RpcResponseFactory.newResponse(RaftError.EINVAL, "Fail to parse peer id %", peerStr);
            }
            addingLearners.add(peer);
        }
        LOG.info("Receive AddLearnersRequest to {} from {}, adding {}.", new Object[]{ctx.node.getNodeId(), done.getRpcCtx().getRemoteAddress(), addingLearners});
        ctx.node.addLearners(addingLearners, status -> {
            if (!status.isOk()) {
                done.run(status);
            } else {
                CliRequests.LearnersOpResponse.Builder rb = CliRequests.LearnersOpResponse.newBuilder();
                for (PeerId peer : oldLearners) {
                    rb.addOldLearners(peer.toString());
                    rb.addNewLearners(peer.toString());
                }
                for (PeerId peer : addingLearners) {
                    if (oldLearners.contains(peer)) continue;
                    rb.addNewLearners(peer.toString());
                }
                done.sendResponse((Message)rb.build());
            }
        });
        return null;
    }

    @Override
    public String interest() {
        return CliRequests.AddLearnersRequest.class.getName();
    }
}

