/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rpc.impl.cli;

import com.alipay.sofa.jraft.entity.PeerId;
import com.alipay.sofa.jraft.error.RaftError;
import com.alipay.sofa.jraft.rpc.CliRequests;
import com.alipay.sofa.jraft.rpc.RpcRequestClosure;
import com.alipay.sofa.jraft.rpc.RpcResponseFactory;
import com.alipay.sofa.jraft.rpc.impl.cli.BaseCliRequestProcessor;
import com.google.protobuf.Message;
import java.util.List;
import java.util.concurrent.Executor;

public class AddPeerRequestProcessor
extends BaseCliRequestProcessor<CliRequests.AddPeerRequest> {
    public AddPeerRequestProcessor(Executor executor) {
        super(executor);
    }

    @Override
    protected String getPeerId(CliRequests.AddPeerRequest request) {
        return request.getLeaderId();
    }

    @Override
    protected String getGroupId(CliRequests.AddPeerRequest request) {
        return request.getGroupId();
    }

    @Override
    protected Message processRequest0(BaseCliRequestProcessor.CliRequestContext ctx, CliRequests.AddPeerRequest request, RpcRequestClosure done) {
        List<PeerId> oldPeers = ctx.node.listPeers();
        PeerId addingPeer = new PeerId();
        String addingPeerIdStr = request.getPeerId();
        if (!addingPeer.parse(addingPeerIdStr)) {
            return RpcResponseFactory.newResponse(RaftError.EINVAL, "Fail to parse peer id %", addingPeerIdStr);
        }
        LOG.info("Receive AddPeerRequest to {} from {}, adding {}", new Object[]{ctx.node.getNodeId(), done.getRpcCtx().getRemoteAddress(), addingPeerIdStr});
        ctx.node.addPeer(addingPeer, status -> {
            if (!status.isOk()) {
                done.run(status);
            } else {
                CliRequests.AddPeerResponse.Builder rb = CliRequests.AddPeerResponse.newBuilder();
                boolean alreadyExists = false;
                for (PeerId oldPeer : oldPeers) {
                    rb.addOldPeers(oldPeer.toString());
                    rb.addNewPeers(oldPeer.toString());
                    if (!oldPeer.equals(addingPeer)) continue;
                    alreadyExists = true;
                }
                if (!alreadyExists) {
                    rb.addNewPeers(addingPeerIdStr);
                }
                done.sendResponse((Message)rb.build());
            }
        });
        return null;
    }

    @Override
    public String interest() {
        return CliRequests.AddPeerRequest.class.getName();
    }
}

