/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rpc.impl.cli;

import com.alipay.sofa.jraft.entity.PeerId;
import com.alipay.sofa.jraft.error.RaftError;
import com.alipay.sofa.jraft.rpc.CliRequests;
import com.alipay.sofa.jraft.rpc.RpcRequestClosure;
import com.alipay.sofa.jraft.rpc.RpcResponseFactory;
import com.alipay.sofa.jraft.rpc.impl.cli.BaseCliRequestProcessor;
import com.google.protobuf.Message;
import java.util.List;
import java.util.concurrent.Executor;

public class RemovePeerRequestProcessor
extends BaseCliRequestProcessor<CliRequests.RemovePeerRequest> {
    public RemovePeerRequestProcessor(Executor executor) {
        super(executor);
    }

    @Override
    protected String getPeerId(CliRequests.RemovePeerRequest request) {
        return request.getLeaderId();
    }

    @Override
    protected String getGroupId(CliRequests.RemovePeerRequest request) {
        return request.getGroupId();
    }

    @Override
    protected Message processRequest0(BaseCliRequestProcessor.CliRequestContext ctx, CliRequests.RemovePeerRequest request, RpcRequestClosure done) {
        List<PeerId> oldPeers = ctx.node.listPeers();
        PeerId removingPeer = new PeerId();
        String removingPeerIdStr = request.getPeerId();
        if (!removingPeer.parse(removingPeerIdStr)) {
            return RpcResponseFactory.newResponse(RaftError.EINVAL, "Fail to parse peer id %s", removingPeerIdStr);
        }
        LOG.info("Receive RemovePeerRequest to {} from {}, removing {}", new Object[]{ctx.node.getNodeId(), done.getRpcCtx().getRemoteAddress(), removingPeerIdStr});
        ctx.node.removePeer(removingPeer, status -> {
            if (!status.isOk()) {
                done.run(status);
            } else {
                CliRequests.RemovePeerResponse.Builder rb = CliRequests.RemovePeerResponse.newBuilder();
                for (PeerId oldPeer : oldPeers) {
                    rb.addOldPeers(oldPeer.toString());
                    if (oldPeer.equals(removingPeer)) continue;
                    rb.addNewPeers(oldPeer.toString());
                }
                done.sendResponse((Message)rb.build());
            }
        });
        return null;
    }

    @Override
    public String interest() {
        return CliRequests.RemovePeerRequest.class.getName();
    }
}

