/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.util;

import com.alipay.sofa.jraft.util.JRaftSignalHandler;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public final class SignalHelper {
    private static final Logger LOG = LoggerFactory.getLogger(SignalHelper.class);
    private static final SignalAccessor SIGNAL_ACCESSOR = SignalHelper.getSignalAccessor0();
    public static final String SIG_USR2 = "USR2";

    public static boolean supportSignal() {
        return SIGNAL_ACCESSOR != null;
    }

    public static boolean addSignal(String signalName, List<JRaftSignalHandler> handlers) {
        if (SIGNAL_ACCESSOR != null) {
            SIGNAL_ACCESSOR.addSignal(signalName, handlers);
            return true;
        }
        return false;
    }

    private static SignalAccessor getSignalAccessor0() {
        return SignalHelper.hasSignal0() ? new SignalAccessor() : null;
    }

    private static boolean hasSignal0() {
        try {
            Class.forName("sun.misc.Signal");
            return true;
        }
        catch (Throwable t) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("sun.misc.Signal: unavailable, {}.", t);
            }
            return false;
        }
    }

    private SignalHelper() {
    }

    static class SignalHandlerAdapter
    implements SignalHandler {
        private final Signal target;
        private final List<JRaftSignalHandler> handlers;

        public static void addSignal(SignalHandlerAdapter adapter) {
            Signal.handle(adapter.target, adapter);
        }

        public SignalHandlerAdapter(Signal target, List<JRaftSignalHandler> handlers) {
            this.target = target;
            this.handlers = handlers;
        }

        @Override
        public void handle(Signal signal) {
            try {
                if (!this.target.equals(signal)) {
                    return;
                }
                LOG.info("Handling signal {}.", (Object)signal);
                for (JRaftSignalHandler h : this.handlers) {
                    h.handle(signal.getName());
                }
            }
            catch (Throwable t) {
                LOG.error("Fail to handle signal: {}.", (Object)signal, (Object)t);
            }
        }
    }

    static class SignalAccessor {
        SignalAccessor() {
        }

        public void addSignal(String signalName, List<JRaftSignalHandler> handlers) {
            Signal signal = new Signal(signalName);
            SignalHandlerAdapter adapter = new SignalHandlerAdapter(signal, handlers);
            Signal.handle(signal, adapter);
        }
    }
}

