/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore;

import com.alicloud.openservices.tablestore.ClientConfiguration;
import com.alicloud.openservices.tablestore.TableStoreCallback;
import com.alicloud.openservices.tablestore.core.AsyncBatchGetRowCompletion;
import com.alicloud.openservices.tablestore.core.AsyncCompletion;
import com.alicloud.openservices.tablestore.core.AsyncGetRangeCompletion;
import com.alicloud.openservices.tablestore.core.AsyncGetRowCompletion;
import com.alicloud.openservices.tablestore.core.BatchGetRowLauncher;
import com.alicloud.openservices.tablestore.core.BatchWriteRowLauncher;
import com.alicloud.openservices.tablestore.core.CallbackImpledFuture;
import com.alicloud.openservices.tablestore.core.Constants;
import com.alicloud.openservices.tablestore.core.CreateTableLauncher;
import com.alicloud.openservices.tablestore.core.DeleteRowLauncher;
import com.alicloud.openservices.tablestore.core.DeleteTableLauncher;
import com.alicloud.openservices.tablestore.core.DescribeStreamLauncher;
import com.alicloud.openservices.tablestore.core.DescribeTableLauncher;
import com.alicloud.openservices.tablestore.core.GetRangeLauncher;
import com.alicloud.openservices.tablestore.core.GetRowLauncher;
import com.alicloud.openservices.tablestore.core.GetShardIteratorLauncher;
import com.alicloud.openservices.tablestore.core.GetStreamRecordLauncher;
import com.alicloud.openservices.tablestore.core.LauncherFactory;
import com.alicloud.openservices.tablestore.core.ListStreamLauncher;
import com.alicloud.openservices.tablestore.core.ListTableLauncher;
import com.alicloud.openservices.tablestore.core.OperationLauncher;
import com.alicloud.openservices.tablestore.core.PutRowLauncher;
import com.alicloud.openservices.tablestore.core.TraceLogger;
import com.alicloud.openservices.tablestore.core.UpdateRowLauncher;
import com.alicloud.openservices.tablestore.core.UpdateTableLauncher;
import com.alicloud.openservices.tablestore.core.auth.ServiceCredentials;
import com.alicloud.openservices.tablestore.core.http.AsyncServiceClient;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.BatchGetRowRequest;
import com.alicloud.openservices.tablestore.model.BatchGetRowResponse;
import com.alicloud.openservices.tablestore.model.BatchWriteRowRequest;
import com.alicloud.openservices.tablestore.model.BatchWriteRowResponse;
import com.alicloud.openservices.tablestore.model.CreateTableRequest;
import com.alicloud.openservices.tablestore.model.CreateTableResponse;
import com.alicloud.openservices.tablestore.model.DeleteRowRequest;
import com.alicloud.openservices.tablestore.model.DeleteRowResponse;
import com.alicloud.openservices.tablestore.model.DeleteTableRequest;
import com.alicloud.openservices.tablestore.model.DeleteTableResponse;
import com.alicloud.openservices.tablestore.model.DescribeStreamRequest;
import com.alicloud.openservices.tablestore.model.DescribeStreamResponse;
import com.alicloud.openservices.tablestore.model.DescribeTableRequest;
import com.alicloud.openservices.tablestore.model.DescribeTableResponse;
import com.alicloud.openservices.tablestore.model.GetRangeRequest;
import com.alicloud.openservices.tablestore.model.GetRangeResponse;
import com.alicloud.openservices.tablestore.model.GetRowRequest;
import com.alicloud.openservices.tablestore.model.GetRowResponse;
import com.alicloud.openservices.tablestore.model.GetShardIteratorRequest;
import com.alicloud.openservices.tablestore.model.GetShardIteratorResponse;
import com.alicloud.openservices.tablestore.model.GetStreamRecordRequest;
import com.alicloud.openservices.tablestore.model.GetStreamRecordResponse;
import com.alicloud.openservices.tablestore.model.ListStreamRequest;
import com.alicloud.openservices.tablestore.model.ListStreamResponse;
import com.alicloud.openservices.tablestore.model.ListTableRequest;
import com.alicloud.openservices.tablestore.model.ListTableResponse;
import com.alicloud.openservices.tablestore.model.PutRowRequest;
import com.alicloud.openservices.tablestore.model.PutRowResponse;
import com.alicloud.openservices.tablestore.model.RetryStrategy;
import com.alicloud.openservices.tablestore.model.UpdateRowRequest;
import com.alicloud.openservices.tablestore.model.UpdateRowResponse;
import com.alicloud.openservices.tablestore.model.UpdateTableRequest;
import com.alicloud.openservices.tablestore.model.UpdateTableResponse;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;

public class InternalClient {
    private static int AVAILABLE_PROCESSORS = Runtime.getRuntime().availableProcessors();
    private String endpoint;
    private String instanceName;
    private ServiceCredentials credentials;
    private AsyncServiceClient httpClient;
    private ScheduledExecutorService retryExecutor;
    private ExecutorService callbackExecutor;
    private ClientConfiguration clientConfig;
    private RetryStrategy retryStrategy;
    private LauncherFactory launcherFactory;
    private Random random = new Random();

    public InternalClient(String endpoint, String accessKeyId, String accessKeySecret, String instanceName) {
        this(endpoint, accessKeyId, accessKeySecret, instanceName, null);
    }

    public InternalClient(String endpoint, String accessKeyId, String accessKeySecret, String instanceName, ClientConfiguration config) {
        this(endpoint, accessKeyId, accessKeySecret, instanceName, config, null);
    }

    public InternalClient(String endpoint, String accessKeyId, String accessKeySecret, String instanceName, ClientConfiguration config, ExecutorService callbackExecutor) {
        this(endpoint, accessKeyId, accessKeySecret, instanceName, config, callbackExecutor, null);
    }

    public InternalClient(String endpoint, String accessKeyId, String accessKeySecret, String instanceName, ClientConfiguration config, ExecutorService callbackExecutor, String stsToken) {
        Preconditions.checkArgument(endpoint != null && !endpoint.isEmpty(), "The end point should not be null or empty.");
        Preconditions.checkArgument(accessKeyId != null && !accessKeyId.isEmpty(), "The access id should not be null or empty.");
        Preconditions.checkArgument(accessKeySecret != null && !accessKeySecret.isEmpty(), "The access key should not be null or empty");
        Preconditions.checkArgument(instanceName != null && !instanceName.isEmpty(), "The name of instance should not be null or empty.");
        Preconditions.checkArgument(instanceName.length() == instanceName.getBytes(Constants.UTF8_CHARSET).length, "InstanceName should not have multibyte character.");
        if (!endpoint.startsWith("http://") && !endpoint.startsWith("https://")) {
            throw new IllegalArgumentException("the endpoint must start with \"http://\" or \"https://\".");
        }
        this.endpoint = endpoint;
        this.credentials = new ServiceCredentials(accessKeyId, accessKeySecret, stsToken);
        if (config == null) {
            config = new ClientConfiguration();
        }
        this.clientConfig = config;
        this.httpClient = new AsyncServiceClient(config);
        this.retryExecutor = Executors.newScheduledThreadPool(config.getRetryThreadCount());
        this.retryStrategy = config.getRetryStrategy();
        this.instanceName = instanceName;
        this.callbackExecutor = callbackExecutor != null ? callbackExecutor : Executors.newFixedThreadPool(AVAILABLE_PROCESSORS);
        this.launcherFactory = new LauncherFactory(endpoint, instanceName, this.httpClient, this.credentials, config);
    }

    public void setExtraHeaders(Map<String, String> extraHeaders) {
        this.httpClient.setExtraHeaders(extraHeaders);
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    private TraceLogger getTraceLogger() {
        String traceId = new UUID(this.random.nextLong(), new Random().nextLong()).toString();
        return new TraceLogger(traceId, this.clientConfig.getTimeThresholdOfTraceLogger());
    }

    public Future<ListTableResponse> listTable(TableStoreCallback<ListTableRequest, ListTableResponse> callback) {
        ListTableRequest request = new ListTableRequest();
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        ListTableLauncher launcher = this.launcherFactory.listTable(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, completion);
        return f;
    }

    public Future<CreateTableResponse> createTable(CreateTableRequest request, TableStoreCallback<CreateTableRequest, CreateTableResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        CreateTableLauncher launcher = this.launcherFactory.createTable(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, completion);
        return f;
    }

    public Future<DescribeTableResponse> describeTable(DescribeTableRequest request, TableStoreCallback<DescribeTableRequest, DescribeTableResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        DescribeTableLauncher launcher = this.launcherFactory.describeTable(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, completion);
        return f;
    }

    public Future<DeleteTableResponse> deleteTable(DeleteTableRequest request, TableStoreCallback<DeleteTableRequest, DeleteTableResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        DeleteTableLauncher launcher = this.launcherFactory.deleteTable(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, completion);
        return f;
    }

    public Future<UpdateTableResponse> updateTable(UpdateTableRequest request, TableStoreCallback<UpdateTableRequest, UpdateTableResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        UpdateTableLauncher launcher = this.launcherFactory.updateTable(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, completion);
        return f;
    }

    public Future<GetRowResponse> getRowInternal(GetRowRequest request, TableStoreCallback<GetRowRequest, GetRowResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        GetRowLauncher launcher = this.launcherFactory.getRow(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, completion);
        return f;
    }

    public Future<GetRowResponse> getRow(GetRowRequest request, TableStoreCallback<GetRowRequest, GetRowResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        GetRowLauncher launcher = this.launcherFactory.getRow(tracer, retry, request);
        AsyncGetRowCompletion completion = new AsyncGetRowCompletion((OperationLauncher<GetRowRequest, GetRowResponse>)launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, completion);
        return f;
    }

    public Future<PutRowResponse> putRow(PutRowRequest request, TableStoreCallback<PutRowRequest, PutRowResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        PutRowLauncher launcher = this.launcherFactory.putRow(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, completion);
        return f;
    }

    public Future<UpdateRowResponse> updateRow(UpdateRowRequest request, TableStoreCallback<UpdateRowRequest, UpdateRowResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        UpdateRowLauncher launcher = this.launcherFactory.updateRow(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, completion);
        return f;
    }

    public Future<DeleteRowResponse> deleteRow(DeleteRowRequest request, TableStoreCallback<DeleteRowRequest, DeleteRowResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        DeleteRowLauncher launcher = this.launcherFactory.deleteRow(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, completion);
        return f;
    }

    public Future<BatchGetRowResponse> batchGetRowInternal(BatchGetRowRequest request, TableStoreCallback<BatchGetRowRequest, BatchGetRowResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        BatchGetRowLauncher launcher = this.launcherFactory.batchGetRow(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, completion);
        return f;
    }

    public Future<BatchGetRowResponse> batchGetRow(BatchGetRowRequest request, TableStoreCallback<BatchGetRowRequest, BatchGetRowResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        BatchGetRowLauncher launcher = this.launcherFactory.batchGetRow(tracer, retry, request);
        AsyncBatchGetRowCompletion completion = new AsyncBatchGetRowCompletion((OperationLauncher)launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, completion);
        return f;
    }

    public Future<BatchWriteRowResponse> batchWriteRow(BatchWriteRowRequest request, TableStoreCallback<BatchWriteRowRequest, BatchWriteRowResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        BatchWriteRowLauncher launcher = this.launcherFactory.batchWriteRow(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, completion);
        return f;
    }

    public Future<GetRangeResponse> getRangeInternal(GetRangeRequest request, TableStoreCallback<GetRangeRequest, GetRangeResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        GetRangeLauncher launcher = this.launcherFactory.getRange(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, completion);
        return f;
    }

    public Future<GetRangeResponse> getRange(GetRangeRequest request, TableStoreCallback<GetRangeRequest, GetRangeResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        GetRangeLauncher launcher = this.launcherFactory.getRange(tracer, retry, request);
        AsyncGetRangeCompletion completion = new AsyncGetRangeCompletion((OperationLauncher<GetRangeRequest, GetRangeResponse>)launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, completion);
        return f;
    }

    public void shutdown() {
        this.retryExecutor.shutdown();
        this.callbackExecutor.shutdown();
        this.httpClient.shutdown();
    }

    public Future<ListStreamResponse> listStream(ListStreamRequest request, TableStoreCallback<ListStreamRequest, ListStreamResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        ListStreamLauncher launcher = this.launcherFactory.listStream(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, completion);
        return f;
    }

    public Future<DescribeStreamResponse> describeStream(DescribeStreamRequest request, TableStoreCallback<DescribeStreamRequest, DescribeStreamResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        DescribeStreamLauncher launcher = this.launcherFactory.describeStream(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, completion);
        return f;
    }

    public Future<GetShardIteratorResponse> getShardIterator(GetShardIteratorRequest request, TableStoreCallback<GetShardIteratorRequest, GetShardIteratorResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        GetShardIteratorLauncher launcher = this.launcherFactory.getShardIterator(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, completion);
        return f;
    }

    public Future<GetStreamRecordResponse> getStreamRecord(GetStreamRecordRequest request, TableStoreCallback<GetStreamRecordRequest, GetStreamRecordResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        GetStreamRecordLauncher launcher = this.launcherFactory.getStreamRecord(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, completion);
        return f;
    }
}

