/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.core;

import com.alicloud.openservices.tablestore.ClientConfiguration;
import com.alicloud.openservices.tablestore.core.BatchGetRowLauncher;
import com.alicloud.openservices.tablestore.core.BatchWriteRowLauncher;
import com.alicloud.openservices.tablestore.core.CreateTableLauncher;
import com.alicloud.openservices.tablestore.core.DeleteRowLauncher;
import com.alicloud.openservices.tablestore.core.DeleteTableLauncher;
import com.alicloud.openservices.tablestore.core.DescribeStreamLauncher;
import com.alicloud.openservices.tablestore.core.DescribeTableLauncher;
import com.alicloud.openservices.tablestore.core.GetRangeLauncher;
import com.alicloud.openservices.tablestore.core.GetRowLauncher;
import com.alicloud.openservices.tablestore.core.GetShardIteratorLauncher;
import com.alicloud.openservices.tablestore.core.GetStreamRecordLauncher;
import com.alicloud.openservices.tablestore.core.ListStreamLauncher;
import com.alicloud.openservices.tablestore.core.ListTableLauncher;
import com.alicloud.openservices.tablestore.core.PutRowLauncher;
import com.alicloud.openservices.tablestore.core.TraceLogger;
import com.alicloud.openservices.tablestore.core.UpdateRowLauncher;
import com.alicloud.openservices.tablestore.core.UpdateTableLauncher;
import com.alicloud.openservices.tablestore.core.auth.ServiceCredentials;
import com.alicloud.openservices.tablestore.core.http.AsyncServiceClient;
import com.alicloud.openservices.tablestore.core.http.OTSUri;
import com.alicloud.openservices.tablestore.model.BatchGetRowRequest;
import com.alicloud.openservices.tablestore.model.BatchWriteRowRequest;
import com.alicloud.openservices.tablestore.model.CreateTableRequest;
import com.alicloud.openservices.tablestore.model.DeleteRowRequest;
import com.alicloud.openservices.tablestore.model.DeleteTableRequest;
import com.alicloud.openservices.tablestore.model.DescribeStreamRequest;
import com.alicloud.openservices.tablestore.model.DescribeTableRequest;
import com.alicloud.openservices.tablestore.model.GetRangeRequest;
import com.alicloud.openservices.tablestore.model.GetRowRequest;
import com.alicloud.openservices.tablestore.model.GetShardIteratorRequest;
import com.alicloud.openservices.tablestore.model.GetStreamRecordRequest;
import com.alicloud.openservices.tablestore.model.ListStreamRequest;
import com.alicloud.openservices.tablestore.model.ListTableRequest;
import com.alicloud.openservices.tablestore.model.PutRowRequest;
import com.alicloud.openservices.tablestore.model.RetryStrategy;
import com.alicloud.openservices.tablestore.model.UpdateRowRequest;
import com.alicloud.openservices.tablestore.model.UpdateTableRequest;
import java.util.HashMap;
import java.util.Map;

public class LauncherFactory {
    private Map<String, Context> contexts = new HashMap<String, Context>();
    private String instanceName;
    private AsyncServiceClient client;
    private ServiceCredentials credentials;
    private ClientConfiguration config;

    public LauncherFactory(String endpoint, String instanceName, AsyncServiceClient client, ServiceCredentials credentials, ClientConfiguration config) {
        this.instanceName = instanceName;
        this.client = client;
        this.credentials = credentials;
        this.config = config;
        this.contexts.put("CreateTable", new Context(new OTSUri(endpoint, "CreateTable")));
        this.contexts.put("DeleteTable", new Context(new OTSUri(endpoint, "DeleteTable")));
        this.contexts.put("DescribeTable", new Context(new OTSUri(endpoint, "DescribeTable")));
        this.contexts.put("ListTable", new Context(new OTSUri(endpoint, "ListTable")));
        this.contexts.put("UpdateTable", new Context(new OTSUri(endpoint, "UpdateTable")));
        this.contexts.put("PutRow", new Context(new OTSUri(endpoint, "PutRow")));
        this.contexts.put("UpdateRow", new Context(new OTSUri(endpoint, "UpdateRow")));
        this.contexts.put("DeleteRow", new Context(new OTSUri(endpoint, "DeleteRow")));
        this.contexts.put("GetRow", new Context(new OTSUri(endpoint, "GetRow")));
        this.contexts.put("BatchGetRow", new Context(new OTSUri(endpoint, "BatchGetRow")));
        this.contexts.put("BatchWriteRow", new Context(new OTSUri(endpoint, "BatchWriteRow")));
        this.contexts.put("GetRange", new Context(new OTSUri(endpoint, "GetRange")));
        this.contexts.put("ListStream", new Context(new OTSUri(endpoint, "ListStream")));
        this.contexts.put("DescribeStream", new Context(new OTSUri(endpoint, "DescribeStream")));
        this.contexts.put("GetShardIterator", new Context(new OTSUri(endpoint, "GetShardIterator")));
        this.contexts.put("GetStreamRecord", new Context(new OTSUri(endpoint, "GetStreamRecord")));
    }

    public CreateTableLauncher createTable(TraceLogger tracer, RetryStrategy retry, CreateTableRequest originRequest) {
        Context ctx = this.contexts.get("CreateTable");
        return new CreateTableLauncher(ctx.uri, tracer, retry, this.instanceName, this.client, this.credentials, this.config, originRequest);
    }

    public DeleteTableLauncher deleteTable(TraceLogger tracer, RetryStrategy retry, DeleteTableRequest originRequest) {
        Context ctx = this.contexts.get("DeleteTable");
        return new DeleteTableLauncher(ctx.uri, tracer, retry, this.instanceName, this.client, this.credentials, this.config, originRequest);
    }

    public DescribeTableLauncher describeTable(TraceLogger tracer, RetryStrategy retry, DescribeTableRequest originRequest) {
        Context ctx = this.contexts.get("DescribeTable");
        return new DescribeTableLauncher(ctx.uri, tracer, retry, this.instanceName, this.client, this.credentials, this.config, originRequest);
    }

    public ListTableLauncher listTable(TraceLogger tracer, RetryStrategy retry, ListTableRequest originRequest) {
        Context ctx = this.contexts.get("ListTable");
        return new ListTableLauncher(ctx.uri, tracer, retry, this.instanceName, this.client, this.credentials, this.config, originRequest);
    }

    public UpdateTableLauncher updateTable(TraceLogger tracer, RetryStrategy retry, UpdateTableRequest originRequest) {
        Context ctx = this.contexts.get("UpdateTable");
        return new UpdateTableLauncher(ctx.uri, tracer, retry, this.instanceName, this.client, this.credentials, this.config, originRequest);
    }

    public PutRowLauncher putRow(TraceLogger tracer, RetryStrategy retry, PutRowRequest originRequest) {
        Context ctx = this.contexts.get("PutRow");
        return new PutRowLauncher(ctx.uri, tracer, retry, this.instanceName, this.client, this.credentials, this.config, originRequest);
    }

    public UpdateRowLauncher updateRow(TraceLogger tracer, RetryStrategy retry, UpdateRowRequest originRequest) {
        Context ctx = this.contexts.get("UpdateRow");
        return new UpdateRowLauncher(ctx.uri, tracer, retry, this.instanceName, this.client, this.credentials, this.config, originRequest);
    }

    public DeleteRowLauncher deleteRow(TraceLogger tracer, RetryStrategy retry, DeleteRowRequest originRequest) {
        Context ctx = this.contexts.get("DeleteRow");
        return new DeleteRowLauncher(ctx.uri, tracer, retry, this.instanceName, this.client, this.credentials, this.config, originRequest);
    }

    public GetRowLauncher getRow(TraceLogger tracer, RetryStrategy retry, GetRowRequest originRequest) {
        Context ctx = this.contexts.get("GetRow");
        return new GetRowLauncher(ctx.uri, tracer, retry, this.instanceName, this.client, this.credentials, this.config, originRequest);
    }

    public BatchGetRowLauncher batchGetRow(TraceLogger tracer, RetryStrategy retry, BatchGetRowRequest originRequest) {
        Context ctx = this.contexts.get("BatchGetRow");
        return new BatchGetRowLauncher(ctx.uri, tracer, retry, this.instanceName, this.client, this.credentials, this.config, originRequest);
    }

    public BatchWriteRowLauncher batchWriteRow(TraceLogger tracer, RetryStrategy retry, BatchWriteRowRequest originRequest) {
        Context ctx = this.contexts.get("BatchWriteRow");
        return new BatchWriteRowLauncher(ctx.uri, tracer, retry, this.instanceName, this.client, this.credentials, this.config, originRequest);
    }

    public GetRangeLauncher getRange(TraceLogger tracer, RetryStrategy retry, GetRangeRequest originRequest) {
        Context ctx = this.contexts.get("GetRange");
        return new GetRangeLauncher(ctx.uri, tracer, retry, this.instanceName, this.client, this.credentials, this.config, originRequest);
    }

    public ListStreamLauncher listStream(TraceLogger tracer, RetryStrategy retry, ListStreamRequest originRequest) {
        Context ctx = this.contexts.get("ListStream");
        return new ListStreamLauncher(ctx.uri, tracer, retry, this.instanceName, this.client, this.credentials, this.config, originRequest);
    }

    public DescribeStreamLauncher describeStream(TraceLogger tracer, RetryStrategy retry, DescribeStreamRequest originRequest) {
        Context ctx = this.contexts.get("DescribeStream");
        return new DescribeStreamLauncher(ctx.uri, tracer, retry, this.instanceName, this.client, this.credentials, this.config, originRequest);
    }

    public GetShardIteratorLauncher getShardIterator(TraceLogger tracer, RetryStrategy retry, GetShardIteratorRequest originRequest) {
        Context ctx = this.contexts.get("GetShardIterator");
        return new GetShardIteratorLauncher(ctx.uri, tracer, retry, this.instanceName, this.client, this.credentials, this.config, originRequest);
    }

    public GetStreamRecordLauncher getStreamRecord(TraceLogger tracer, RetryStrategy retry, GetStreamRecordRequest originRequest) {
        Context ctx = this.contexts.get("GetStreamRecord");
        return new GetStreamRecordLauncher(ctx.uri, tracer, retry, this.instanceName, this.client, this.credentials, this.config, originRequest);
    }

    private class Context {
        public OTSUri uri;

        public Context(OTSUri uri) {
            this.uri = uri;
        }
    }
}

