/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model;

import com.alicloud.openservices.tablestore.core.utils.CalculateHelper;
import com.alicloud.openservices.tablestore.core.utils.Jsonizable;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.PrimaryKeyColumn;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PrimaryKey
implements Comparable<PrimaryKey>,
Jsonizable {
    private PrimaryKeyColumn[] primaryKey;
    private Map<String, PrimaryKeyColumn> nameMap;
    private int dataSize = -1;

    public PrimaryKey(PrimaryKeyColumn[] primaryKey) {
        Preconditions.checkArgument(primaryKey != null && primaryKey.length != 0, "The primary key should not be null or empty.");
        this.primaryKey = primaryKey;
    }

    public PrimaryKey(List<PrimaryKeyColumn> primaryKey) {
        Preconditions.checkArgument(primaryKey != null && !primaryKey.isEmpty(), "The primary key should not be null or empty.");
        this.primaryKey = primaryKey.toArray(new PrimaryKeyColumn[primaryKey.size()]);
    }

    public PrimaryKey() {
    }

    public PrimaryKeyColumn getPrimaryKeyColumn(String name) {
        Preconditions.checkArgument(this.primaryKey != null && this.primaryKey.length != 0, "The primary key should not be set before getPrimaryKeyColumn.");
        if (this.nameMap == null) {
            this.makeMap();
        }
        return this.nameMap.get(name);
    }

    public PrimaryKeyColumn getPrimaryKeyColumn(int index) {
        Preconditions.checkArgument(this.primaryKey != null && this.primaryKey.length != 0, "The primary key should not be set before getPrimaryKeyColumn.");
        if (index < 0 || index >= this.primaryKey.length) {
            throw new IllegalArgumentException("The index is out of bounds.");
        }
        return this.primaryKey[index];
    }

    public PrimaryKeyColumn[] getPrimaryKeyColumns() {
        if (this.primaryKey == null) {
            return null;
        }
        return Arrays.copyOf(this.primaryKey, this.primaryKey.length);
    }

    public Map<String, PrimaryKeyColumn> getPrimaryKeyColumnsMap() {
        Preconditions.checkArgument(this.primaryKey != null && this.primaryKey.length != 0, "The primary key should not be set before getPrimaryKeyColumnsMap.");
        if (this.nameMap == null) {
            this.makeMap();
        }
        return Collections.unmodifiableMap(this.nameMap);
    }

    public boolean contains(String name) {
        Preconditions.checkArgument(this.primaryKey != null && this.primaryKey.length != 0, "The primary key should not be set.");
        if (this.nameMap == null) {
            this.makeMap();
        }
        return this.nameMap.containsKey(name);
    }

    public int size() {
        if (this.primaryKey == null) {
            return 0;
        }
        return this.primaryKey.length;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    private void makeMap() {
        this.nameMap = new HashMap<String, PrimaryKeyColumn>(this.primaryKey.length);
        for (PrimaryKeyColumn column : this.primaryKey) {
            this.nameMap.put(column.getName(), column);
        }
    }

    public int getSize() {
        if (this.primaryKey == null) {
            return 0;
        }
        if (this.dataSize == -1) {
            this.dataSize = 0;
            for (PrimaryKeyColumn key : this.primaryKey) {
                this.dataSize += CalculateHelper.calcStringSizeInBytes(key.getName());
                this.dataSize += key.getValue().getSize();
            }
        }
        return this.dataSize;
    }

    @Override
    public int compareTo(PrimaryKey target) {
        if (this.primaryKey.length != target.primaryKey.length) {
            throw new IllegalArgumentException("The schema of the two primary key compared is not the same.");
        }
        for (int i = 0; i < this.primaryKey.length; ++i) {
            int ret = this.primaryKey[i].compareTo(target.primaryKey[i]);
            if (ret == 0) continue;
            return ret;
        }
        return 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (PrimaryKeyColumn pk : this.primaryKey) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(pk.getName());
            sb.append(":");
            sb.append(pk.getValue());
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof PrimaryKey)) {
            return false;
        }
        PrimaryKey pk = (PrimaryKey)o;
        if (this.primaryKey.length != pk.primaryKey.length) {
            return false;
        }
        for (int i = 0; i < this.primaryKey.length; ++i) {
            if (this.primaryKey[i].equals(pk.primaryKey[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Arrays.hashCode(this.primaryKey);
    }

    @Override
    public String jsonize() {
        StringBuilder sb = new StringBuilder();
        this.jsonize(sb, "\n  ");
        return sb.toString();
    }

    @Override
    public void jsonize(StringBuilder sb, String newline) {
        sb.append("[");
        Iterator<PrimaryKeyColumn> iter = Arrays.asList(this.primaryKey).iterator();
        if (iter.hasNext()) {
            iter.next().jsonize(sb, newline);
            while (iter.hasNext()) {
                sb.append(", ");
                iter.next().jsonize(sb, newline);
            }
        }
        sb.append("]");
    }
}

