/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model;

import com.alicloud.openservices.tablestore.core.utils.Base64;
import com.alicloud.openservices.tablestore.core.utils.Bytes;
import com.alicloud.openservices.tablestore.core.utils.Jsonizable;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.Column;
import com.alicloud.openservices.tablestore.model.PrimaryKeyValue;
import java.io.IOException;

public class PrimaryKeyColumn
implements Comparable<PrimaryKeyColumn>,
Jsonizable {
    private String name;
    private byte[] rawData;
    private PrimaryKeyValue value;

    public PrimaryKeyColumn(String name, PrimaryKeyValue value) {
        Preconditions.checkArgument(name != null && !name.isEmpty(), "The name of primary key should not be null or empty.");
        Preconditions.checkNotNull(value, "The value of primary key should not be null.");
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public byte[] getNameRawData() {
        if (this.rawData == null) {
            this.rawData = Bytes.toBytes(this.name);
        }
        return this.rawData;
    }

    public PrimaryKeyValue getValue() {
        return this.value;
    }

    public Column toColumn() throws IOException {
        return new Column(this.getName(), this.getValue().toColumnValue());
    }

    public String toString() {
        return "'" + this.name + "':" + this.value;
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.value.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof PrimaryKeyColumn)) {
            return false;
        }
        PrimaryKeyColumn col = (PrimaryKeyColumn)o;
        return this.name.equals(col.name) && this.value.equals(col.value);
    }

    @Override
    public int compareTo(PrimaryKeyColumn target) {
        if (!this.name.equals(target.name)) {
            throw new IllegalArgumentException("The name of primary key to be compared must be the same.");
        }
        return this.value.compareTo(target.value);
    }

    @Override
    public String jsonize() {
        StringBuilder sb = new StringBuilder();
        this.jsonize(sb, "\n  ");
        return sb.toString();
    }

    @Override
    public void jsonize(StringBuilder sb, String newline) {
        sb.append("{\"Name\": \"");
        sb.append(this.name);
        sb.append("\", \"Type\": \"");
        sb.append(this.value.getType().toString());
        sb.append("\", \"Value\": ");
        switch (this.value.getType()) {
            case INTEGER: {
                sb.append(this.value.asLong());
                break;
            }
            case STRING: {
                sb.append("\"");
                sb.append(this.value.asString());
                sb.append("\"");
                break;
            }
            case BINARY: {
                sb.append("\"");
                sb.append(Base64.toBase64String(this.value.asBinary()));
                sb.append("\"");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type: " + (Object)((Object)this.value.getType()));
            }
        }
        sb.append("}");
    }
}

