/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model;

import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.Condition;
import com.alicloud.openservices.tablestore.model.IRow;
import com.alicloud.openservices.tablestore.model.PrimaryKey;
import com.alicloud.openservices.tablestore.model.ReturnType;

public class RowChange
implements IRow {
    private String tableName;
    private PrimaryKey primaryKey;
    private Condition condition;
    private ReturnType returnType;

    public RowChange(String tableName, PrimaryKey primaryKey) {
        Preconditions.checkArgument(tableName != null && !tableName.isEmpty(), "The name of table should not be null or empty.");
        Preconditions.checkArgument(primaryKey != null && !primaryKey.isEmpty(), "The primary key of row should not be null or empty.");
        this.tableName = tableName;
        this.primaryKey = primaryKey;
        this.condition = new Condition();
        this.returnType = ReturnType.RT_NONE;
    }

    public RowChange(String tableName) {
        Preconditions.checkArgument(tableName != null && !tableName.isEmpty(), "The name of table should not be null or empty.");
        this.tableName = tableName;
        this.condition = new Condition();
        this.returnType = ReturnType.RT_NONE;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setPrimaryKey(PrimaryKey primaryKey) {
        Preconditions.checkNotNull(primaryKey, "primaryKey");
        this.primaryKey = primaryKey;
    }

    @Override
    public PrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    @Override
    public int compareTo(IRow row) {
        return this.primaryKey.compareTo(row.getPrimaryKey());
    }

    public ReturnType getReturnType() {
        return this.returnType;
    }

    public void setReturnType(ReturnType returnType) {
        this.returnType = returnType;
    }
}

