/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model;

import com.alicloud.openservices.tablestore.core.utils.Jsonizable;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.PrimaryKeyOption;
import com.alicloud.openservices.tablestore.model.PrimaryKeySchema;
import com.alicloud.openservices.tablestore.model.PrimaryKeyType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class TableMeta
implements Jsonizable {
    private String tableName;
    private List<PrimaryKeySchema> primaryKey = new ArrayList<PrimaryKeySchema>();

    public TableMeta(String tableName) {
        Preconditions.checkArgument(tableName != null && !tableName.isEmpty(), "The name of table should not be null or empty.");
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        Preconditions.checkArgument(tableName != null && !tableName.isEmpty(), "The name of table should not be null or empty.");
        this.tableName = tableName;
    }

    public Map<String, PrimaryKeyType> getPrimaryKeyMap() {
        LinkedHashMap<String, PrimaryKeyType> result = new LinkedHashMap<String, PrimaryKeyType>();
        for (PrimaryKeySchema key : this.primaryKey) {
            result.put(key.getName(), key.getType());
        }
        return result;
    }

    public List<PrimaryKeySchema> getPrimaryKeyList() {
        return Collections.unmodifiableList(this.primaryKey);
    }

    public void addPrimaryKeyColumn(String name, PrimaryKeyType type) {
        Preconditions.checkArgument(name != null && !name.isEmpty(), "The name of primary key should not be null or empty.");
        Preconditions.checkNotNull(type, "The type of primary key should not be null.");
        this.primaryKey.add(new PrimaryKeySchema(name, type));
    }

    public void addPrimaryKeyColumn(String name, PrimaryKeyType type, PrimaryKeyOption option) {
        Preconditions.checkArgument(name != null && !name.isEmpty(), "The name of primary key should not be null or empty.");
        Preconditions.checkNotNull(type, "The type of primary key should not be null.");
        Preconditions.checkNotNull(option, "The option of primary key should not be null.");
        this.primaryKey.add(new PrimaryKeySchema(name, type, option));
    }

    public void addAutoIncrementPrimaryKeyColumn(String name) {
        Preconditions.checkArgument(name != null && !name.isEmpty(), "The name of primary key should not be null or empty.");
        this.primaryKey.add(new PrimaryKeySchema(name, PrimaryKeyType.INTEGER, PrimaryKeyOption.AUTO_INCREMENT));
    }

    public void addPrimaryKeyColumn(PrimaryKeySchema key) {
        Preconditions.checkNotNull(key, "The primary key schema should not be null.");
        this.primaryKey.add(key);
    }

    public void addPrimaryKeyColumns(List<PrimaryKeySchema> pks) {
        Preconditions.checkArgument(pks != null && !pks.isEmpty(), "The primary key schema should not be null or empty.");
        this.primaryKey.addAll(pks);
    }

    public void addPrimaryKeyColumns(PrimaryKeySchema[] pks) {
        Preconditions.checkArgument(pks != null && pks.length != 0, "The primary key schema should not be null or empty.");
        Collections.addAll(this.primaryKey, pks);
    }

    public String toString() {
        String s = "TableName: " + this.tableName + ", PrimaryKeySchema: ";
        boolean first = true;
        for (PrimaryKeySchema pk : this.primaryKey) {
            if (first) {
                first = false;
            } else {
                s = s + ",";
            }
            s = s + pk.toString();
        }
        return s;
    }

    @Override
    public String jsonize() {
        StringBuilder sb = new StringBuilder();
        this.jsonize(sb, "\n  ");
        return sb.toString();
    }

    @Override
    public void jsonize(StringBuilder sb, String newline) {
        PrimaryKeySchema pk;
        sb.append('{');
        sb.append(newline);
        sb.append("\"TableName\": \"");
        sb.append(this.tableName);
        sb.append('\"');
        sb.append(",");
        sb.append(newline);
        sb.append("\"PrimaryKey\": [");
        newline = newline + "  ";
        sb.append(newline);
        ListIterator<PrimaryKeySchema> iter = this.primaryKey.listIterator();
        if (iter.hasNext()) {
            pk = iter.next();
            pk.jsonize(sb, newline + "  ");
        }
        while (iter.hasNext()) {
            sb.append(",");
            sb.append(newline);
            pk = iter.next();
            pk.jsonize(sb, newline + "  ");
        }
        sb.append("]}");
    }
}

