/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.core.protocol;

import com.alicloud.openservices.tablestore.core.protocol.Search;
import com.alicloud.openservices.tablestore.core.protocol.SearchAggregationParser;
import com.alicloud.openservices.tablestore.core.protocol.SearchQueryParser;
import com.alicloud.openservices.tablestore.core.protocol.SearchSortParser;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.search.GeoPoint;
import com.alicloud.openservices.tablestore.model.search.groupby.GroupBy;
import com.alicloud.openservices.tablestore.model.search.groupby.GroupByField;
import com.alicloud.openservices.tablestore.model.search.groupby.GroupByFilter;
import com.alicloud.openservices.tablestore.model.search.groupby.GroupByGeoDistance;
import com.alicloud.openservices.tablestore.model.search.groupby.GroupByRange;
import com.alicloud.openservices.tablestore.model.search.groupby.Range;
import com.alicloud.openservices.tablestore.model.search.query.Query;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SearchGroupByParser {
    private static GroupByField toGroupByField(String groupByName, ByteString groupByByteString) throws IOException {
        Search.GroupByField pb = Search.GroupByField.parseFrom(groupByByteString);
        GroupByField groupBy = new GroupByField();
        groupBy.setGroupByName(groupByName);
        if (pb.hasFieldName()) {
            groupBy.setFieldName(pb.getFieldName());
        }
        if (pb.hasSort()) {
            groupBy.setGroupBySorters(SearchSortParser.toGroupBySort(pb.getSort()));
        }
        if (pb.hasSize()) {
            groupBy.setSize(pb.getSize());
        }
        if (pb.hasSubGroupBys()) {
            groupBy.setSubGroupBys(SearchGroupByParser.toGroupBys(pb.getSubGroupBys()));
        }
        if (pb.hasSubAggs()) {
            groupBy.setSubAggregations(SearchAggregationParser.toAggregations(pb.getSubAggs()));
        }
        return groupBy;
    }

    private static GroupByGeoDistance toGroupByGeoDistance(String groupByName, ByteString groupByByteString) throws IOException {
        Search.GroupByGeoDistance pb = Search.GroupByGeoDistance.parseFrom(groupByByteString);
        GroupByGeoDistance groupBy = new GroupByGeoDistance();
        groupBy.setGroupByName(groupByName);
        if (pb.hasFieldName()) {
            groupBy.setFieldName(pb.getFieldName());
        }
        if (pb.hasOrigin()) {
            groupBy.setOrigin(SearchGroupByParser.toGeoPoint(pb.getOrigin()));
        }
        List<Search.Range> rangesList = pb.getRangesList();
        ArrayList<Range> list = new ArrayList<Range>();
        for (Search.Range range : rangesList) {
            list.add(SearchGroupByParser.toRange(range));
        }
        groupBy.setRanges(list);
        if (pb.hasSubGroupBys()) {
            groupBy.setSubGroupBys(SearchGroupByParser.toGroupBys(pb.getSubGroupBys()));
        }
        if (pb.hasSubAggs()) {
            groupBy.setSubAggregations(SearchAggregationParser.toAggregations(pb.getSubAggs()));
        }
        return groupBy;
    }

    private static GroupByRange toGroupByRange(String groupByName, ByteString groupByByteString) throws IOException {
        Search.GroupByRange pb = Search.GroupByRange.parseFrom(groupByByteString);
        GroupByRange groupBy = new GroupByRange();
        groupBy.setGroupByName(groupByName);
        if (pb.hasFieldName()) {
            groupBy.setFieldName(pb.getFieldName());
        }
        List<Search.Range> rangesList = pb.getRangesList();
        ArrayList<Range> list = new ArrayList<Range>();
        for (Search.Range range : rangesList) {
            list.add(SearchGroupByParser.toRange(range));
        }
        groupBy.setRanges(list);
        if (pb.hasSubGroupBys()) {
            groupBy.setSubGroupBys(SearchGroupByParser.toGroupBys(pb.getSubGroupBys()));
        }
        if (pb.hasSubAggs()) {
            groupBy.setSubAggregations(SearchAggregationParser.toAggregations(pb.getSubAggs()));
        }
        return groupBy;
    }

    private static GroupByFilter toGroupByFilter(String groupByName, ByteString groupByByteString) throws IOException {
        Search.GroupByFilter pb = Search.GroupByFilter.parseFrom(groupByByteString);
        GroupByFilter groupBy = new GroupByFilter();
        groupBy.setGroupByName(groupByName);
        List<Search.Query> rangesList = pb.getFiltersList();
        ArrayList<Query> list = new ArrayList<Query>();
        for (Search.Query query : rangesList) {
            list.add(SearchQueryParser.toQuery(query));
        }
        groupBy.setFilters(list);
        if (pb.hasSubGroupBys()) {
            groupBy.setSubGroupBys(SearchGroupByParser.toGroupBys(pb.getSubGroupBys()));
        }
        if (pb.hasSubAggs()) {
            groupBy.setSubAggregations(SearchAggregationParser.toAggregations(pb.getSubAggs()));
        }
        return groupBy;
    }

    private static Range toRange(Search.Range pb) {
        Preconditions.checkArgument(pb.hasFrom(), "Search.Range must has 'from'");
        Preconditions.checkArgument(pb.hasTo(), "Search.Range must has 'to'");
        return new Range(pb.getFrom(), pb.getTo());
    }

    private static GeoPoint toGeoPoint(Search.GeoPoint pb) {
        Preconditions.checkArgument(pb.hasLat(), "Search.GeoPoint must has 'lat'");
        Preconditions.checkArgument(pb.hasLon(), "Search.GeoPoint must has 'lon'");
        return new GeoPoint(pb.getLat(), pb.getLon());
    }

    public static GroupBy toGroupBy(Search.GroupBy pb) throws IOException {
        String groupByName = pb.getName();
        ByteString body = pb.getBody();
        Search.GroupByType type = pb.getType();
        switch (type) {
            case GROUP_BY_FIELD: {
                return SearchGroupByParser.toGroupByField(groupByName, body);
            }
            case GROUP_BY_GEO_DISTANCE: {
                return SearchGroupByParser.toGroupByGeoDistance(groupByName, body);
            }
            case GROUP_BY_RANGE: {
                return SearchGroupByParser.toGroupByRange(groupByName, body);
            }
            case GROUP_BY_FILTER: {
                return SearchGroupByParser.toGroupByFilter(groupByName, body);
            }
        }
        throw new IllegalArgumentException("unknown GroupByType: " + type.name());
    }

    public static List<GroupBy> toGroupBys(Search.GroupBys pb) throws IOException {
        ArrayList<GroupBy> groupBys = new ArrayList<GroupBy>();
        for (Search.GroupBy groupBy : pb.getGroupBysList()) {
            groupBys.add(SearchGroupByParser.toGroupBy(groupBy));
        }
        return groupBys;
    }
}

