/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model.search.groupby;

import com.alicloud.openservices.tablestore.core.protocol.SearchGroupByBuilder;
import com.alicloud.openservices.tablestore.model.search.GeoPoint;
import com.alicloud.openservices.tablestore.model.search.agg.Aggregation;
import com.alicloud.openservices.tablestore.model.search.agg.AggregationBuilder;
import com.alicloud.openservices.tablestore.model.search.groupby.GroupBy;
import com.alicloud.openservices.tablestore.model.search.groupby.GroupByBuilder;
import com.alicloud.openservices.tablestore.model.search.groupby.GroupByType;
import com.alicloud.openservices.tablestore.model.search.groupby.Range;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.List;

public class GroupByGeoDistance
implements GroupBy {
    private GroupByType groupByType = GroupByType.GROUP_BY_GEO_DISTANCE;
    private String groupByName;
    private String fieldName;
    private GeoPoint origin;
    private List<Range> ranges;
    private List<Aggregation> subAggregations;
    private List<GroupBy> subGroupBys;

    public GroupByGeoDistance() {
    }

    private GroupByGeoDistance(Builder builder) {
        this.groupByName = builder.groupByName;
        this.fieldName = builder.fieldName;
        this.origin = builder.origin;
        this.ranges = builder.ranges;
        this.subAggregations = builder.subAggregations;
        this.subGroupBys = builder.subGroupBys;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public String getGroupByName() {
        return this.groupByName;
    }

    @Override
    public GroupByType getGroupByType() {
        return this.groupByType;
    }

    @Override
    public ByteString serialize() {
        return SearchGroupByBuilder.buildGroupByGeoDistance(this).toByteString();
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public GeoPoint getOrigin() {
        return this.origin;
    }

    public List<Range> getRanges() {
        return this.ranges;
    }

    public List<Aggregation> getSubAggregations() {
        return this.subAggregations;
    }

    public List<GroupBy> getSubGroupBys() {
        return this.subGroupBys;
    }

    public GroupByGeoDistance setGroupByName(String groupByName) {
        this.groupByName = groupByName;
        return this;
    }

    public GroupByGeoDistance setFieldName(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    public GroupByGeoDistance setOrigin(GeoPoint origin) {
        this.origin = origin;
        return this;
    }

    public GroupByGeoDistance setRanges(List<Range> ranges) {
        this.ranges = ranges;
        return this;
    }

    public GroupByGeoDistance setSubAggregations(List<Aggregation> subAggregations) {
        this.subAggregations = subAggregations;
        return this;
    }

    public GroupByGeoDistance setSubGroupBys(List<GroupBy> subGroupBys) {
        this.subGroupBys = subGroupBys;
        return this;
    }

    public static final class Builder
    implements GroupByBuilder {
        private String groupByName;
        private String fieldName;
        private GeoPoint origin;
        private List<Range> ranges;
        private List<Aggregation> subAggregations;
        private List<GroupBy> subGroupBys;

        private Builder() {
        }

        public Builder groupByName(String groupByName) {
            this.groupByName = groupByName;
            return this;
        }

        public Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public Builder origin(double lat, double lon) {
            this.origin = new GeoPoint(lat, lon);
            return this;
        }

        public Builder addRange(double from, double to) {
            if (this.ranges == null) {
                this.ranges = new ArrayList<Range>();
            }
            this.ranges.add(new Range(from, to));
            return this;
        }

        public Builder addSubAggregation(AggregationBuilder builder) {
            if (this.subAggregations == null) {
                this.subAggregations = new ArrayList<Aggregation>();
            }
            this.subAggregations.add(builder.build());
            return this;
        }

        public Builder addSubGroupBy(GroupByBuilder builder) {
            if (this.subGroupBys == null) {
                this.subGroupBys = new ArrayList<GroupBy>();
            }
            this.subGroupBys.add(builder.build());
            return this;
        }

        @Override
        public GroupByGeoDistance build() {
            return new GroupByGeoDistance(this);
        }
    }
}

