/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model.search.query;

import com.alicloud.openservices.tablestore.core.protocol.SearchQueryBuilder;
import com.alicloud.openservices.tablestore.model.search.query.Query;
import com.alicloud.openservices.tablestore.model.search.query.QueryBuilder;
import com.alicloud.openservices.tablestore.model.search.query.QueryType;
import com.google.protobuf.ByteString;

public class PrefixQuery
implements Query {
    private QueryType queryType = QueryType.QueryType_PrefixQuery;
    private String fieldName;
    private String prefix;
    private float weight = 1.0f;

    @Override
    public QueryType getQueryType() {
        return this.queryType;
    }

    @Override
    public ByteString serialize() {
        return SearchQueryBuilder.buildPrefixQuery(this).toByteString();
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public float getWeight() {
        return this.weight;
    }

    public void setWeight(float weight) {
        this.weight = weight;
    }

    protected static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder
    implements QueryBuilder {
        private String fieldName;
        private String prefix;
        private float weight = 1.0f;

        public Builder weight(float weight) {
            this.weight = weight;
            return this;
        }

        private Builder() {
        }

        public Builder field(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        @Override
        public PrefixQuery build() {
            PrefixQuery prefixQuery = new PrefixQuery();
            prefixQuery.setFieldName(this.fieldName);
            prefixQuery.setPrefix(this.prefix);
            prefixQuery.setWeight(this.weight);
            return prefixQuery;
        }
    }
}

