/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.timeline.core;

import com.alicloud.openservices.tablestore.SyncClient;
import com.alicloud.openservices.tablestore.model.CreateTableRequest;
import com.alicloud.openservices.tablestore.model.DeleteRowRequest;
import com.alicloud.openservices.tablestore.model.DeleteTableRequest;
import com.alicloud.openservices.tablestore.model.GetRowRequest;
import com.alicloud.openservices.tablestore.model.GetRowResponse;
import com.alicloud.openservices.tablestore.model.PrimaryKey;
import com.alicloud.openservices.tablestore.model.PrimaryKeySchema;
import com.alicloud.openservices.tablestore.model.PutRowRequest;
import com.alicloud.openservices.tablestore.model.Row;
import com.alicloud.openservices.tablestore.model.RowDeleteChange;
import com.alicloud.openservices.tablestore.model.RowPutChange;
import com.alicloud.openservices.tablestore.model.RowUpdateChange;
import com.alicloud.openservices.tablestore.model.SingleRowQueryCriteria;
import com.alicloud.openservices.tablestore.model.TableMeta;
import com.alicloud.openservices.tablestore.model.TableOptions;
import com.alicloud.openservices.tablestore.model.UpdateRowRequest;
import com.alicloud.openservices.tablestore.model.search.CreateSearchIndexRequest;
import com.alicloud.openservices.tablestore.model.search.DeleteSearchIndexRequest;
import com.alicloud.openservices.tablestore.model.search.SearchQuery;
import com.alicloud.openservices.tablestore.model.search.SearchRequest;
import com.alicloud.openservices.tablestore.model.search.SearchResponse;
import com.alicloud.openservices.tablestore.timeline.TimelineMetaStore;
import com.alicloud.openservices.tablestore.timeline.model.TimelineIdentifier;
import com.alicloud.openservices.tablestore.timeline.model.TimelineMeta;
import com.alicloud.openservices.tablestore.timeline.model.TimelineMetaSchema;
import com.alicloud.openservices.tablestore.timeline.query.SearchParameter;
import com.alicloud.openservices.tablestore.timeline.query.SearchResult;
import com.alicloud.openservices.tablestore.timeline.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;

public class TimelineMetaStoreImpl
implements TimelineMetaStore {
    private final SyncClient client;
    private final TimelineMetaSchema schema;

    public TimelineMetaStoreImpl(SyncClient client, TimelineMetaSchema schema) {
        this.client = client;
        this.schema = schema;
    }

    @Override
    public TimelineMeta read(TimelineIdentifier identifier) {
        GetRowResponse response;
        SingleRowQueryCriteria criteria = new SingleRowQueryCriteria(this.schema.getTableName());
        criteria.setPrimaryKey(Utils.identifierToPrimaryKey(identifier));
        criteria.setMaxVersions(1);
        GetRowRequest request = new GetRowRequest(criteria);
        try {
            response = this.client.getRow(request);
        }
        catch (Exception e) {
            throw Utils.convertException(e);
        }
        return Utils.rowToMeta(this.schema.getIdentifierSchema(), response.getRow());
    }

    @Override
    public SearchResult<TimelineMeta> search(SearchParameter searchParameter) {
        return this.search(Utils.toSearchQuery(searchParameter));
    }

    @Override
    public SearchResult<TimelineMeta> search(SearchQuery searchQuery) {
        SearchResponse response;
        SearchRequest request = new SearchRequest(this.schema.getTableName(), this.schema.getIndexName(), searchQuery);
        SearchRequest.ColumnsToGet columnsToGet = new SearchRequest.ColumnsToGet();
        columnsToGet.setReturnAll(true);
        request.setColumnsToGet(columnsToGet);
        try {
            response = this.client.search(request);
        }
        catch (Exception e) {
            throw Utils.convertException(e);
        }
        ArrayList entries = new ArrayList(response.getRows().size());
        for (Row row : response.getRows()) {
            TimelineMeta meta = Utils.rowToMeta(this.schema.getIdentifierSchema(), row);
            SearchResult.Entry<TimelineMeta> entry = new SearchResult.Entry<TimelineMeta>(meta.getIdentifier(), meta);
            entries.add(entry);
        }
        SearchResult<TimelineMeta> result = new SearchResult<TimelineMeta>(entries, response.isAllSuccess(), response.getTotalCount(), response.getNextToken());
        return result;
    }

    @Override
    public TimelineMeta insert(TimelineMeta meta) {
        Row row = Utils.metaToRow(meta);
        PutRowRequest request = new PutRowRequest();
        RowPutChange rowChange = new RowPutChange(this.schema.getTableName());
        rowChange.setPrimaryKey(row.getPrimaryKey());
        rowChange.addColumns(row.getColumns());
        request.setRowChange(rowChange);
        try {
            this.client.putRow(request);
        }
        catch (Exception e) {
            throw Utils.convertException(e);
        }
        return meta;
    }

    @Override
    public TimelineMeta update(TimelineMeta meta) {
        Row row = Utils.metaToRow(meta);
        UpdateRowRequest request = new UpdateRowRequest();
        RowUpdateChange rowChange = new RowUpdateChange(this.schema.getTableName());
        rowChange.setPrimaryKey(row.getPrimaryKey());
        rowChange.put(Arrays.asList(row.getColumns()));
        request.setRowChange(rowChange);
        try {
            this.client.updateRow(request);
        }
        catch (Exception e) {
            throw Utils.convertException(e);
        }
        return meta;
    }

    @Override
    public void delete(TimelineIdentifier identifier) {
        PrimaryKey primaryKey = Utils.identifierToPrimaryKey(identifier);
        DeleteRowRequest request = new DeleteRowRequest();
        RowDeleteChange rowChange = new RowDeleteChange(this.schema.getTableName());
        rowChange.setPrimaryKey(primaryKey);
        request.setRowChange(rowChange);
        try {
            this.client.deleteRow(request);
        }
        catch (Exception e) {
            throw Utils.convertException(e);
        }
    }

    @Override
    public void prepareTables() {
        TableMeta tableMeta = new TableMeta(this.schema.getTableName());
        for (PrimaryKeySchema key : this.schema.getIdentifierSchema().getKeys()) {
            tableMeta.addPrimaryKeyColumn(key);
        }
        TableOptions tableOptions = new TableOptions();
        tableOptions.setTimeToLive(-1);
        tableOptions.setMaxVersions(1);
        CreateTableRequest request = new CreateTableRequest(tableMeta, tableOptions);
        try {
            this.client.createTable(request);
        }
        catch (Exception e) {
            throw Utils.convertException(e);
        }
        if (this.schema.hasMetaIndex()) {
            CreateSearchIndexRequest csRequest = new CreateSearchIndexRequest();
            csRequest.setTableName(this.schema.getTableName());
            csRequest.setIndexName(this.schema.getIndexName());
            csRequest.setIndexSchema(this.schema.getIndexSchema());
            try {
                this.client.createSearchIndex(csRequest);
            }
            catch (Exception e) {
                throw Utils.convertException(e);
            }
        }
    }

    @Override
    public void dropAllTables() {
        if (this.schema.hasMetaIndex()) {
            DeleteSearchIndexRequest dsRequest = new DeleteSearchIndexRequest();
            dsRequest.setTableName(this.schema.getTableName());
            dsRequest.setIndexName(this.schema.getIndexName());
            try {
                this.client.deleteSearchIndex(dsRequest);
            }
            catch (Exception e) {
                throw Utils.convertException(e);
            }
        }
        DeleteTableRequest request = new DeleteTableRequest(this.schema.getTableName());
        try {
            this.client.deleteTable(request);
        }
        catch (Exception e) {
            throw Utils.convertException(e);
        }
    }

    @Override
    public void close() {
    }
}

