/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.timestream.model;

import com.alicloud.openservices.tablestore.ClientException;
import java.util.Map;
import java.util.TreeMap;

public class TimestreamIdentifier {
    private String name;
    private Map<String, String> tags;

    private TimestreamIdentifier(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    private TimestreamIdentifier setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public String getTagValue(String name) {
        return this.tags.get(name);
    }

    public int hashCode() {
        return this.name.hashCode() * 31 + this.tags.hashCode();
    }

    private static boolean compareMap(Map<String, String> a, Map<String, String> b) {
        if (a.size() != b.size()) {
            return false;
        }
        for (Map.Entry<String, String> entry1 : a.entrySet()) {
            String val2;
            String val1 = entry1.getValue();
            if (val1.equals(val2 = b.get(entry1.getKey()))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof TimestreamIdentifier)) {
            return false;
        }
        TimestreamIdentifier val = (TimestreamIdentifier)o;
        if (!this.name.equals(val.name)) {
            return false;
        }
        return TimestreamIdentifier.compareMap(this.tags, val.tags);
    }

    public int getDataSize() {
        int size = this.name.length();
        for (Map.Entry<String, String> entry1 : this.tags.entrySet()) {
            size += entry1.getKey().length() + entry1.getValue().length();
        }
        return size;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("name=");
        sb.append(this.name);
        for (String name : this.tags.keySet()) {
            sb.append(", ");
            sb.append(name);
            sb.append("=");
            sb.append(this.tags.get(name));
        }
        return sb.toString();
    }

    public static final class Builder {
        private String name = null;
        private Map<String, String> tags = new TreeMap<String, String>();

        public Builder(String name) {
            if (name.length() > 100) {
                throw new ClientException(String.format("The length(%s) of name larger than %d.", name.length(), 100));
            }
            this.name = name;
        }

        private void checkKeyParams(String param) {
            if (param.indexOf("=") >= 0) {
                throw new ClientException("Illegal character exist: =.");
            }
        }

        public Builder setTags(TreeMap<String, String> tags) {
            for (String key : tags.keySet()) {
                this.checkKeyParams(key);
            }
            this.tags = tags;
            return this;
        }

        public Builder addTag(String name, String value) {
            this.checkKeyParams(name);
            this.tags.put(name, value);
            return this;
        }

        public TimestreamIdentifier build() {
            TimestreamIdentifier identifier = new TimestreamIdentifier(this.name);
            identifier.setTags(this.tags);
            return identifier;
        }
    }
}

