/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.tunnel.worker;

import com.alicloud.openservices.tablestore.TableStoreException;
import com.alicloud.openservices.tablestore.TunnelClientInterface;
import com.alicloud.openservices.tablestore.model.tunnel.internal.CheckpointRequest;
import com.alicloud.openservices.tablestore.model.tunnel.internal.GetCheckpointRequest;
import com.alicloud.openservices.tablestore.model.tunnel.internal.GetCheckpointResponse;
import com.alicloud.openservices.tablestore.tunnel.worker.ICheckpointer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Checkpointer
implements ICheckpointer {
    private static final Logger LOG = LoggerFactory.getLogger(Checkpointer.class);
    private TunnelClientInterface client;
    private String tunnelId;
    private String clientId;
    private String channelId;
    private long sequenceNumber;

    public Checkpointer(TunnelClientInterface client, String tunnelId, String clientId, String channelId, long sequenceNumber) {
        this.client = client;
        this.tunnelId = tunnelId;
        this.clientId = clientId;
        this.channelId = channelId;
        this.sequenceNumber = sequenceNumber;
    }

    @Override
    public void checkpoint(String token) {
        block6: {
            try {
                if (token == null) {
                    token = "finished";
                }
                this.client.checkpoint(new CheckpointRequest(this.tunnelId, this.clientId, this.channelId, token, this.sequenceNumber));
                ++this.sequenceNumber;
                LOG.info("Finish do checkpoint,token:{}, checkpointer: {}", (Object)token, (Object)this);
            }
            catch (TableStoreException te) {
                if (!te.getErrorCode().equals("OTSSequenceNumberNotMatch")) break block6;
                try {
                    GetCheckpointResponse getResp = this.client.getCheckpoint(new GetCheckpointRequest(this.tunnelId, this.clientId, this.channelId));
                    this.sequenceNumber = getResp.getSequenceNumber() + 1L;
                }
                catch (Exception ge) {
                    String errorMsg = String.format("Checkpoint failed %s and check sequence failed %s", te, ge);
                    LOG.warn(errorMsg);
                    throw new TableStoreException(errorMsg, "OTSClientError");
                }
            }
            catch (Exception e) {
                LOG.warn("Checkpoint occurs error, detail: {}", (Object)e.toString());
            }
        }
    }

    public TunnelClientInterface getClient() {
        return this.client;
    }

    public void setClient(TunnelClientInterface client) {
        this.client = client;
    }

    public String getTunnelId() {
        return this.tunnelId;
    }

    public void setTunnelId(String tunnelId) {
        this.tunnelId = tunnelId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(long sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[TunnelId: ").append(this.tunnelId).append(", ClientId: ").append(this.clientId).append(", ChannelId: ").append(this.channelId).append(", SequenceNumber: ").append(this.sequenceNumber).append("]");
        return sb.toString();
    }
}

