/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.writer;

import com.alicloud.openservices.tablestore.model.RowChange;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class WriterResult {
    private boolean isAllFinished = true;
    private final int totalCount;
    private final AtomicReferenceArray<RowChangeStatus> rowChangeStatusList;

    public WriterResult(int totalCount, AtomicReferenceArray<RowChangeStatus> rowChangeStatusList) {
        this.totalCount = totalCount;
        this.rowChangeStatusList = rowChangeStatusList;
    }

    public List<RowChangeStatus> getSucceedRows() {
        LinkedList<RowChangeStatus> succeed = new LinkedList<RowChangeStatus>();
        for (int i = 0; i < this.rowChangeStatusList.length(); ++i) {
            RowChangeStatus rowChangeStatus = this.rowChangeStatusList.get(i);
            if (!rowChangeStatus.isSucceed()) continue;
            succeed.add(rowChangeStatus);
        }
        return succeed;
    }

    public List<RowChangeStatus> getFailedRows() {
        LinkedList<RowChangeStatus> failed = new LinkedList<RowChangeStatus>();
        for (int i = 0; i < this.rowChangeStatusList.length(); ++i) {
            RowChangeStatus rowChangeStatus = this.rowChangeStatusList.get(i);
            if (rowChangeStatus.isSucceed()) continue;
            failed.add(rowChangeStatus);
        }
        return failed;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public boolean isAllFinished() {
        return this.isAllFinished;
    }

    public boolean isAllSucceed() {
        LinkedList<RowChangeStatus> failed = new LinkedList<RowChangeStatus>();
        for (int i = 0; i < this.rowChangeStatusList.length(); ++i) {
            RowChangeStatus rowChangeStatus = this.rowChangeStatusList.get(i);
            if (rowChangeStatus.isSucceed()) continue;
            failed.add(rowChangeStatus);
        }
        return failed.size() == 0;
    }

    public static class RowChangeStatus {
        private boolean succeed;
        private Exception exception;
        private RowChange rowChange;

        public RowChangeStatus(boolean succeed, RowChange rowChange, Exception exception) {
            this.succeed = succeed;
            this.rowChange = rowChange;
            this.exception = exception;
        }

        public RowChange getRowChange() {
            return this.rowChange;
        }

        public boolean isSucceed() {
            return this.succeed;
        }

        public Exception getException() {
            return this.exception;
        }
    }
}

