/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.timestream.model.aggregator;

import com.alicloud.openservices.tablestore.model.ColumnValue;
import com.alicloud.openservices.tablestore.timestream.model.TimestreamIdentifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Item
implements Cloneable {
    private String groupByValue;
    private List<String> gourpByColumn;
    private Map<String, ColumnValue> columnValueMap = new TreeMap<String, ColumnValue>();
    private TimestreamIdentifier meta;

    public Item(List<String> gourpByColumn, TimestreamIdentifier meta) {
        this.gourpByColumn = gourpByColumn;
        this.meta = meta;
    }

    public Item add(String name, ColumnValue value) {
        this.columnValueMap.put(name, value);
        return this;
    }

    public Item add(String name, String value) {
        this.columnValueMap.put(name, ColumnValue.fromString(value));
        return this;
    }

    public Item add(String name, long value) {
        this.columnValueMap.put(name, ColumnValue.fromLong(value));
        return this;
    }

    public ColumnValue getColumnValue(String name) {
        return this.columnValueMap.get(name);
    }

    public String groupBy() {
        if (this.groupByValue == null) {
            StringBuilder sb = new StringBuilder();
            for (String key : this.gourpByColumn) {
                sb.append(this.columnValueMap.get(key).asString());
                sb.append(',');
            }
            this.groupByValue = sb.toString();
        }
        return this.groupByValue;
    }

    public TimestreamIdentifier getMeta() {
        return this.meta;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        block5: for (Map.Entry<String, ColumnValue> key : this.columnValueMap.entrySet()) {
            switch (key.getValue().getType()) {
                case STRING: {
                    sb.append(key.getKey() + ":" + key.getValue().asString() + ", ");
                    continue block5;
                }
                case DOUBLE: {
                    sb.append(key.getKey() + ":" + key.getValue().asDouble() + ", ");
                    continue block5;
                }
                case INTEGER: {
                    sb.append(key.getKey() + ":" + key.getValue().asLong() + ", ");
                    continue block5;
                }
            }
            throw new RuntimeException("not support");
        }
        sb.append("}");
        return sb.toString();
    }

    public Item clone() {
        Item newItem = new Item(this.gourpByColumn, this.meta);
        block5: for (Map.Entry<String, ColumnValue> e : this.columnValueMap.entrySet()) {
            ColumnValue v = e.getValue();
            switch (v.getType()) {
                case INTEGER: {
                    newItem.columnValueMap.put(e.getKey(), ColumnValue.fromLong(v.asLong()));
                    continue block5;
                }
                case DOUBLE: {
                    newItem.columnValueMap.put(e.getKey(), ColumnValue.fromDouble(v.asDouble()));
                    continue block5;
                }
                case STRING: {
                    newItem.columnValueMap.put(e.getKey(), ColumnValue.fromString(v.asString()));
                    continue block5;
                }
            }
            throw new RuntimeException("not support");
        }
        return newItem;
    }

    public static List<Item> buildItems(List<String> gourpByColumn, List<TimestreamIdentifier> metas) {
        ArrayList<Item> itemList = new ArrayList<Item>(metas.size());
        for (TimestreamIdentifier m3 : metas) {
            itemList.add(new Item(gourpByColumn, m3));
        }
        return itemList;
    }
}

