/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.core.protocol;

import com.alicloud.openservices.tablestore.core.protocol.PlainBufferBuilder;
import com.alicloud.openservices.tablestore.core.protocol.PlainBufferCell;
import com.alicloud.openservices.tablestore.core.protocol.PlainBufferExtension;
import com.alicloud.openservices.tablestore.core.protocol.PlainBufferOutputStream;
import com.alicloud.openservices.tablestore.core.protocol.PlainBufferRow;
import com.alicloud.openservices.tablestore.core.protocol.PlainBufferSequenceInfo;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.ColumnValue;
import com.alicloud.openservices.tablestore.model.PrimaryKeyValue;
import java.io.IOException;

public class PlainBufferCodedOutputStream {
    private PlainBufferOutputStream output = null;

    public PlainBufferCodedOutputStream(PlainBufferOutputStream output) {
        Preconditions.checkNotNull(output, "The plainBufferOutputStream should not be null.");
        this.output = output;
    }

    public void writeHeader() throws IOException {
        this.output.writeRawLittleEndian32(117);
    }

    public void writeTag(byte tag) throws IOException {
        this.output.writeRawByte(tag);
    }

    public void writeCellName(byte[] name) throws IOException {
        this.writeTag((byte)4);
        this.output.writeRawLittleEndian32(name.length);
        this.output.writeBytes(name);
    }

    public void writeCellValue(PrimaryKeyValue value) throws IOException {
        this.writeTag((byte)5);
        if (value.isInfMin()) {
            this.output.writeRawLittleEndian32(1);
            this.output.writeRawByte((byte)9);
            return;
        }
        if (value.isInfMax()) {
            this.output.writeRawLittleEndian32(1);
            this.output.writeRawByte((byte)10);
            return;
        }
        if (value.isPlaceHolderForAutoIncr()) {
            this.output.writeRawLittleEndian32(1);
            this.output.writeRawByte((byte)11);
            return;
        }
        switch (value.getType()) {
            case STRING: {
                byte[] rawData = value.asStringInBytes();
                int prefixLength = 5;
                this.output.writeRawLittleEndian32(5 + rawData.length);
                this.output.writeRawByte((byte)3);
                this.output.writeRawLittleEndian32(rawData.length);
                this.output.writeBytes(rawData);
                break;
            }
            case INTEGER: {
                this.output.writeRawLittleEndian32(9);
                this.output.writeRawByte((byte)0);
                this.output.writeRawLittleEndian64(value.asLong());
                break;
            }
            case BINARY: {
                byte[] rawData = value.asBinary();
                int prefixLength = 5;
                this.output.writeRawLittleEndian32(5 + rawData.length);
                this.output.writeRawByte((byte)7);
                this.output.writeRawLittleEndian32(rawData.length);
                this.output.writeBytes(rawData);
                break;
            }
            default: {
                throw new IOException("Bug: unsupported primary key type: " + (Object)((Object)value.getType()));
            }
        }
    }

    public void writeCellValue(ColumnValue value) throws IOException {
        this.writeTag((byte)5);
        switch (value.getType()) {
            case STRING: {
                byte[] rawData = value.asStringInBytes();
                int prefixLength = 5;
                this.output.writeRawLittleEndian32(5 + rawData.length);
                this.output.writeRawByte((byte)3);
                this.output.writeRawLittleEndian32(rawData.length);
                this.output.writeBytes(rawData);
                break;
            }
            case INTEGER: {
                this.output.writeRawLittleEndian32(9);
                this.output.writeRawByte((byte)0);
                this.output.writeRawLittleEndian64(value.asLong());
                break;
            }
            case BINARY: {
                byte[] rawData = value.asBinary();
                int prefixLength = 5;
                this.output.writeRawLittleEndian32(5 + rawData.length);
                this.output.writeRawByte((byte)7);
                this.output.writeRawLittleEndian32(rawData.length);
                this.output.writeBytes(rawData);
                break;
            }
            case DOUBLE: {
                this.output.writeRawLittleEndian32(9);
                this.output.writeRawByte((byte)1);
                this.output.writeDouble(value.asDouble());
                break;
            }
            case BOOLEAN: {
                this.output.writeRawLittleEndian32(2);
                this.output.writeRawByte((byte)2);
                this.output.writeBoolean(value.asBoolean());
                break;
            }
            default: {
                throw new IOException("Bug: unsupported column type: " + (Object)((Object)value.getType()));
            }
        }
    }

    public void writeCell(PlainBufferCell cell) throws IOException {
        this.writeTag((byte)3);
        if (cell.hasCellName()) {
            this.writeCellName(cell.getNameRawData());
        }
        if (cell.hasCellValue()) {
            if (cell.isPk()) {
                this.writeCellValue(cell.getPkCellValue());
            } else {
                this.writeCellValue(cell.getCellValue());
            }
        }
        if (cell.hasCellType()) {
            this.writeTag((byte)6);
            this.output.writeRawByte(cell.getCellType());
        }
        if (cell.hasCellTimestamp()) {
            this.writeTag((byte)7);
            this.output.writeRawLittleEndian64(cell.getCellTimestamp());
        }
        this.writeTag((byte)10);
        this.output.writeRawByte(cell.getChecksum());
    }

    public void writeExtension(PlainBufferExtension extension) throws IOException {
        this.writeTag((byte)11);
        this.output.writeRawLittleEndian32(PlainBufferBuilder.computeSkipLengthForExtensionTag(extension));
        int extensionCount = 0;
        if (extension.hasSeq()) {
            this.writeSequenceInfo(extension.getSequenceInfo());
            ++extensionCount;
        }
        if (extensionCount == 0) {
            throw new IOException("no extension tag is writen.");
        }
    }

    public void writeSequenceInfo(PlainBufferSequenceInfo sequenceInfo) throws IOException {
        this.writeTag((byte)12);
        this.output.writeRawLittleEndian32(PlainBufferBuilder.computeSkipLengthForSequenceInfo());
        this.writeTag((byte)13);
        this.output.writeRawLittleEndian32(sequenceInfo.getEpoch());
        this.writeTag((byte)14);
        this.output.writeRawLittleEndian64(sequenceInfo.getTimestamp());
        this.writeTag((byte)15);
        this.output.writeRawLittleEndian32(sequenceInfo.getRowIndex());
    }

    public void writeRow(PlainBufferRow row) throws IOException {
        this.writeTag((byte)1);
        for (PlainBufferCell cell : row.getPrimaryKey()) {
            this.writeCell(cell);
        }
        if (!row.getCells().isEmpty()) {
            this.writeTag((byte)2);
            for (PlainBufferCell cell : row.getCells()) {
                this.writeCell(cell);
            }
        }
        if (row.hasDeleteMarker()) {
            this.writeTag((byte)8);
        }
        if (row.hasExtension()) {
            this.writeExtension(row.getExtension());
        }
        this.writeTag((byte)9);
        this.output.writeRawByte(row.getChecksum());
    }

    public void writeRowWithHeader(PlainBufferRow row) throws IOException {
        this.writeHeader();
        this.writeRow(row);
    }

    public void writePrimaryKeyValueWithoutLengthPrefix(PrimaryKeyValue value) throws IOException {
        if (value.isInfMin()) {
            this.output.writeRawByte((byte)9);
            return;
        }
        if (value.isInfMax()) {
            this.output.writeRawByte((byte)10);
            return;
        }
        if (value.isPlaceHolderForAutoIncr()) {
            this.output.writeRawByte((byte)11);
            return;
        }
        switch (value.getType()) {
            case STRING: {
                byte[] rawData = value.asStringInBytes();
                this.output.writeRawByte((byte)3);
                this.output.writeRawLittleEndian32(rawData.length);
                this.output.writeBytes(rawData);
                break;
            }
            case INTEGER: {
                this.output.writeRawByte((byte)0);
                this.output.writeRawLittleEndian64(value.asLong());
                break;
            }
            case BINARY: {
                byte[] rawData = value.asBinary();
                this.output.writeRawByte((byte)7);
                this.output.writeRawLittleEndian32(rawData.length);
                this.output.writeBytes(rawData);
                break;
            }
            default: {
                throw new IOException("Bug: unsupported primary key type: " + (Object)((Object)value.getType()));
            }
        }
    }

    public void writeColumnValueWithoutLengthPrefix(ColumnValue value) throws IOException {
        switch (value.getType()) {
            case STRING: {
                byte[] rawData = value.asStringInBytes();
                this.output.writeRawByte((byte)3);
                this.output.writeRawLittleEndian32(rawData.length);
                this.output.writeBytes(rawData);
                break;
            }
            case INTEGER: {
                this.output.writeRawByte((byte)0);
                this.output.writeRawLittleEndian64(value.asLong());
                break;
            }
            case BINARY: {
                byte[] rawData = value.asBinary();
                this.output.writeRawByte((byte)7);
                this.output.writeRawLittleEndian32(rawData.length);
                this.output.writeBytes(rawData);
                break;
            }
            case DOUBLE: {
                this.output.writeRawByte((byte)1);
                this.output.writeDouble(value.asDouble());
                break;
            }
            case BOOLEAN: {
                this.output.writeRawByte((byte)2);
                this.output.writeBoolean(value.asBoolean());
                break;
            }
            default: {
                throw new IOException("Bug: unsupported column type: " + (Object)((Object)value.getType()));
            }
        }
    }
}

