/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.core.utils;

import com.alicloud.openservices.tablestore.core.utils.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;

public class HttpUtil {
    public static String urlEncode(String value, String charset) throws UnsupportedEncodingException {
        return value != null ? URLEncoder.encode(value, charset).replace("+", "%20").replace("*", "%2A").replace("%7E", "~") : null;
    }

    public static String paramToQueryString(Map<String, String> params, String charset) throws UnsupportedEncodingException {
        if (params == null || params.size() == 0) {
            return null;
        }
        StringBuilder paramString = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> p : params.entrySet()) {
            String key = p.getKey();
            String val = p.getValue();
            if (!first) {
                paramString.append("&");
            }
            paramString.append(key);
            if (val != null) {
                paramString.append("=").append(HttpUtil.urlEncode(val, charset));
            }
            first = false;
        }
        return paramString.toString();
    }

    public static boolean validateEndpointArgs(String endpoint) {
        return StringUtils.matchRegexPattern("^(?i)http(s)?(?-i)://[a-zA-Z0-9._-]+(:\\d{1,5})?(/)?$", endpoint);
    }

    public static boolean checkSSRF(String param) {
        return StringUtils.matchRegexPattern("^[a-zA-Z0-9_-]+$", param);
    }
}

