/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model;

import com.alicloud.openservices.tablestore.core.utils.OptionalValue;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.IRow;
import com.alicloud.openservices.tablestore.model.PrimaryKey;
import com.alicloud.openservices.tablestore.model.RowQueryCriteria;

public class SingleRowQueryCriteria
extends RowQueryCriteria
implements IRow {
    private PrimaryKey primaryKey;
    private OptionalValue<byte[]> token = new OptionalValue("Token");

    public SingleRowQueryCriteria(String tableName) {
        super(tableName);
    }

    public SingleRowQueryCriteria(String tableName, PrimaryKey primaryKey) {
        super(tableName);
        this.setPrimaryKey(primaryKey);
    }

    public void setPrimaryKey(PrimaryKey primaryKey) {
        Preconditions.checkArgument(primaryKey != null && !primaryKey.isEmpty(), "The row's primary key should not be null or empty.");
        this.primaryKey = primaryKey;
    }

    public byte[] getToken() {
        if (!this.token.isValueSet()) {
            throw new IllegalStateException("The value of token is not set.");
        }
        return this.token.getValue();
    }

    public void setToken(byte[] token) {
        if (token != null) {
            this.token.setValue(token);
        }
    }

    public boolean hasSetToken() {
        return this.token.isValueSet();
    }

    @Override
    public int compareTo(IRow row) {
        return this.primaryKey.compareTo(row.getPrimaryKey());
    }

    @Override
    public PrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }
}

