/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.timeline.model;

import com.alicloud.openservices.tablestore.TableStoreCallback;
import com.alicloud.openservices.tablestore.model.PrimaryKey;
import com.alicloud.openservices.tablestore.model.RowPutChange;
import com.alicloud.openservices.tablestore.timeline.TimelineCallback;
import com.alicloud.openservices.tablestore.timeline.model.TimelineCallbackImpledFuture;
import com.alicloud.openservices.tablestore.timeline.model.TimelineEntry;
import com.alicloud.openservices.tablestore.timeline.model.TimelineIdentifier;
import com.alicloud.openservices.tablestore.timeline.model.TimelineMessage;
import java.util.concurrent.Future;

public class RowPutChangeWithCallback
extends RowPutChange {
    private TimelineIdentifier identifier = null;
    private TimelineCallbackImpledFuture<TimelineMessage, TimelineEntry> future = new TimelineCallbackImpledFuture();

    public RowPutChangeWithCallback(String tableName, PrimaryKey primaryKey) {
        super(tableName, primaryKey);
    }

    public void setComplete(TimelineEntry timelineEntry) {
        TimelineMessage message = new TimelineMessage();
        message.setFields(this.getColumnsToPut());
        this.future.onCompleted(message, timelineEntry);
    }

    public void setFailed(Exception ex) {
        TimelineMessage message = new TimelineMessage();
        message.setFields(this.getColumnsToPut());
        this.future.onFailed(message, ex);
    }

    public RowPutChangeWithCallback watchBy(final TimelineCallback callback) {
        TimelineMessage message = new TimelineMessage();
        message.setFields(this.getColumnsToPut());
        TableStoreCallback<TimelineMessage, TimelineEntry> tsCallback = new TableStoreCallback<TimelineMessage, TimelineEntry>(){

            @Override
            public void onCompleted(TimelineMessage message, TimelineEntry timelineEntry) {
                callback.onCompleted(RowPutChangeWithCallback.this.identifier, message, timelineEntry);
            }

            @Override
            public void onFailed(TimelineMessage message, Exception e) {
                callback.onFailed(RowPutChangeWithCallback.this.identifier, message, e);
            }
        };
        this.future.watchBy(tsCallback);
        return this;
    }

    public RowPutChangeWithCallback withTimelineIdentifier(TimelineIdentifier identifier) {
        this.identifier = identifier;
        return this;
    }

    public Future<TimelineEntry> getFuture() {
        return this.future;
    }
}

