/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.timeline.model;

import com.alicloud.openservices.tablestore.model.PrimaryKeySchema;
import com.alicloud.openservices.tablestore.model.PrimaryKeyType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TimelineIdentifierSchema {
    private List<PrimaryKeySchema> keys;

    private TimelineIdentifierSchema(List<PrimaryKeySchema> keys) {
        this.keys = keys;
    }

    public List<PrimaryKeySchema> getKeys() {
        return Collections.unmodifiableList(this.keys);
    }

    public static class Builder {
        List<PrimaryKeySchema> keys = new ArrayList<PrimaryKeySchema>(4);

        public Builder addStringField(String name) {
            this.keys.add(new PrimaryKeySchema(name, PrimaryKeyType.STRING));
            return this;
        }

        public Builder addLongField(String name) {
            this.keys.add(new PrimaryKeySchema(name, PrimaryKeyType.INTEGER));
            return this;
        }

        public Builder addBinaryField(String name) {
            this.keys.add(new PrimaryKeySchema(name, PrimaryKeyType.BINARY));
            return this;
        }

        public TimelineIdentifierSchema build() {
            TimelineIdentifierSchema schema = new TimelineIdentifierSchema(this.keys);
            this.keys = null;
            return schema;
        }
    }
}

