/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.timestream;

import com.alicloud.openservices.tablestore.AsyncClient;
import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.DefaultTableStoreWriter;
import com.alicloud.openservices.tablestore.TableStoreCallback;
import com.alicloud.openservices.tablestore.TableStoreException;
import com.alicloud.openservices.tablestore.TableStoreWriter;
import com.alicloud.openservices.tablestore.model.ConsumedCapacity;
import com.alicloud.openservices.tablestore.model.CreateTableRequest;
import com.alicloud.openservices.tablestore.model.CreateTableResponse;
import com.alicloud.openservices.tablestore.model.DeleteTableRequest;
import com.alicloud.openservices.tablestore.model.DeleteTableResponse;
import com.alicloud.openservices.tablestore.model.DescribeTableRequest;
import com.alicloud.openservices.tablestore.model.DescribeTableResponse;
import com.alicloud.openservices.tablestore.model.PrimaryKeySchema;
import com.alicloud.openservices.tablestore.model.RowChange;
import com.alicloud.openservices.tablestore.model.TableMeta;
import com.alicloud.openservices.tablestore.model.TableOptions;
import com.alicloud.openservices.tablestore.model.search.CreateSearchIndexRequest;
import com.alicloud.openservices.tablestore.model.search.CreateSearchIndexResponse;
import com.alicloud.openservices.tablestore.model.search.DeleteSearchIndexRequest;
import com.alicloud.openservices.tablestore.model.search.DeleteSearchIndexResponse;
import com.alicloud.openservices.tablestore.model.search.FieldSchema;
import com.alicloud.openservices.tablestore.model.search.FieldType;
import com.alicloud.openservices.tablestore.model.search.IndexSchema;
import com.alicloud.openservices.tablestore.model.search.IndexSetting;
import com.alicloud.openservices.tablestore.model.search.ListSearchIndexRequest;
import com.alicloud.openservices.tablestore.model.search.ListSearchIndexResponse;
import com.alicloud.openservices.tablestore.model.search.SearchIndexInfo;
import com.alicloud.openservices.tablestore.timestream.TimestreamDB;
import com.alicloud.openservices.tablestore.timestream.TimestreamDBConfiguration;
import com.alicloud.openservices.tablestore.timestream.TimestreamDataTable;
import com.alicloud.openservices.tablestore.timestream.TimestreamMetaTable;
import com.alicloud.openservices.tablestore.timestream.internal.MetaCacheManager;
import com.alicloud.openservices.tablestore.timestream.internal.TableMetaGenerator;
import com.alicloud.openservices.tablestore.timestream.internal.Utils;
import com.alicloud.openservices.tablestore.timestream.model.AttributeIndexSchema;
import com.alicloud.openservices.tablestore.writer.WriterConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimestreamDBClient
implements TimestreamDB {
    private Logger logger = LoggerFactory.getLogger(TimestreamDBClient.class);
    private TimestreamDBConfiguration config;
    private WriterConfig writerConfig;
    private String metaTableName;
    private String indexName;
    private ExecutorService executor;
    private AsyncClient asyncClient;
    private TableStoreWriter metaWriter;
    private MetaCacheManager metaCacheManager;
    private Map<String, TimestreamDataTable> dataTableMap = new HashMap<String, TimestreamDataTable>();
    private TableStoreCallback<RowChange, ConsumedCapacity> callback;
    private AtomicBoolean closed = new AtomicBoolean(false);
    private boolean writeMeta;

    public TimestreamDBClient(AsyncClient asyncClient, TimestreamDBConfiguration config) {
        this(asyncClient, config, new WriterConfig(), null);
    }

    public TimestreamDBClient(AsyncClient asyncClient, TimestreamDBConfiguration config, WriterConfig writerConfig, TableStoreCallback<RowChange, ConsumedCapacity> callback) {
        this.asyncClient = asyncClient;
        this.config = config;
        this.writerConfig = writerConfig;
        this.callback = callback;
        this.metaTableName = this.config.getMetaTableName();
        this.indexName = this.metaTableName + "_INDEX";
        this.writeMeta = config.getDumpMeta();
        this.executor = Executors.newFixedThreadPool(this.config.getThreadNumForWriter());
        try {
            this.tryInitMetaWriter();
        }
        catch (TableStoreException e) {
            this.logger.warn("Failed to init meta writer:" + e.getMessage());
        }
        catch (ClientException e) {
            this.logger.warn("Failed to init meta writer:" + e.toString());
        }
        this.logger.info("End initialize client");
    }

    @Override
    public synchronized void close() {
        if (this.closed.get()) {
            throw new ClientException("The client has already been closed.");
        }
        if (this.metaCacheManager != null) {
            this.metaCacheManager.close();
        }
        if (this.metaWriter != null) {
            this.metaWriter.close();
        }
        for (TimestreamDataTable dataTable : this.dataTableMap.values()) {
            dataTable.close();
        }
        this.asyncClient.shutdown();
        this.executor.shutdown();
        this.closed.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryInitMetaWriter() {
        if (!this.writeMeta) {
            return;
        }
        if (this.metaWriter == null) {
            TimestreamDBClient timestreamDBClient = this;
            synchronized (timestreamDBClient) {
                if (this.metaWriter == null) {
                    this.logger.info("Begin to init meta writer");
                    this.checkMetaTableExist();
                    this.checkIndexMetaExist();
                    this.metaWriter = new DefaultTableStoreWriter(this.asyncClient, this.metaTableName, this.writerConfig, null, this.executor);
                    this.metaCacheManager = new MetaCacheManager(this.metaTableName, this.config.getIntervalDumpMeta(TimeUnit.SECONDS), this.config.getMetaCacheSize(), this.metaWriter);
                    this.logger.info("End to init meta writer");
                }
            }
        }
    }

    @Override
    public void createMetaTable() {
        this.createMetaTable(null);
    }

    @Override
    public void createMetaTable(List<AttributeIndexSchema> indexForAttributes) {
        if (indexForAttributes != null) {
            for (AttributeIndexSchema schema : indexForAttributes) {
                String name = schema.getFieldName();
                if (!name.equals("h") && !name.equals("n") && !name.equals("t") && !name.equals("s")) continue;
                throw new ClientException("Name of attribute for indexes cannot be h/n/t/s.");
            }
        }
        TableMeta tableMeta = TableMetaGenerator.getMetaTableMeta(this.metaTableName);
        TableOptions tableOptions = new TableOptions();
        CreateTableRequest request = new CreateTableRequest(tableMeta, tableOptions);
        tableOptions.setMaxVersions(1);
        tableOptions.setTimeToLive(-1);
        Future<CreateTableResponse> res = this.asyncClient.createTable(request, null);
        Utils.waitForFuture(res);
        this.createSearchIndexForMeta(indexForAttributes);
        this.tryInitMetaWriter();
    }

    private void createSearchIndexForMeta(List<AttributeIndexSchema> indexForAttributes) {
        CreateSearchIndexRequest request = new CreateSearchIndexRequest(this.metaTableName, this.indexName);
        IndexSchema indexSchema = this.getIndexSchema(indexForAttributes);
        IndexSetting indexSetting = new IndexSetting();
        indexSetting.setRoutingFields(Arrays.asList("n"));
        indexSchema.setIndexSetting(indexSetting);
        request.setIndexSchema(indexSchema);
        Future<CreateSearchIndexResponse> future = this.asyncClient.createSearchIndex(request, null);
        Utils.waitForFuture(future);
    }

    private IndexSchema getIndexSchema(List<AttributeIndexSchema> indexForAttributes) {
        IndexSchema indexSchema = new IndexSchema();
        ArrayList<FieldSchema> fieldSchemas = new ArrayList<FieldSchema>();
        if (indexForAttributes != null) {
            for (AttributeIndexSchema schema : indexForAttributes) {
                fieldSchemas.add(schema.getFieldSchema());
            }
        }
        fieldSchemas.add(new FieldSchema("h", FieldType.KEYWORD));
        fieldSchemas.add(new FieldSchema("n", FieldType.KEYWORD).setIndex(true).setEnableSortAndAgg(true));
        fieldSchemas.add(new FieldSchema("t", FieldType.KEYWORD).setIndex(true).setIsArray(true).setEnableSortAndAgg(true));
        fieldSchemas.add(new FieldSchema("s", FieldType.LONG).setIndex(true).setStore(true));
        indexSchema.setFieldSchemas(fieldSchemas);
        return indexSchema;
    }

    @Override
    public void deleteMetaTable() {
        this.deleteSearchIndexForMeta();
        DeleteTableRequest request = new DeleteTableRequest(this.metaTableName);
        Future<DeleteTableResponse> res = this.asyncClient.deleteTable(request, null);
        Utils.waitForFuture(res);
    }

    private void deleteSearchIndexForMeta() {
        DeleteSearchIndexRequest request = new DeleteSearchIndexRequest();
        request.setTableName(this.metaTableName);
        request.setIndexName(this.indexName);
        Future<DeleteSearchIndexResponse> future = this.asyncClient.deleteSearchIndex(request, null);
        Utils.waitForFuture(future);
    }

    private void checkMetaTableExist() {
        DescribeTableRequest request = new DescribeTableRequest(this.metaTableName);
        DescribeTableResponse resp = Utils.waitForFuture(this.asyncClient.describeTable(request, null));
        TableMeta tableMeta = resp.getTableMeta();
        TableMeta tableMetaExpect = TableMetaGenerator.getMetaTableMeta(this.metaTableName);
        List<PrimaryKeySchema> pks = tableMeta.getPrimaryKeyList();
        List<PrimaryKeySchema> pksExpect = tableMetaExpect.getPrimaryKeyList();
        if (pks.size() != pksExpect.size()) {
            throw new ClientException("Same table with different meta exist: " + this.metaTableName);
        }
        for (int i = 0; i < pks.size(); ++i) {
            if (pks.get(i).equals(pksExpect.get(i))) continue;
            throw new ClientException("Same table with different meta exist: " + this.metaTableName);
        }
    }

    private void checkIndexMetaExist() {
        ListSearchIndexRequest request = new ListSearchIndexRequest();
        request.setTableName(this.metaTableName);
        ListSearchIndexResponse resp = Utils.waitForFuture(this.asyncClient.listSearchIndex(request, null));
        List<SearchIndexInfo> indexInfos = resp.getIndexInfos();
        if (indexInfos.size() == 0) {
            throw new ClientException(String.format("Index for meta(%s) not exist: %s", this.metaTableName, this.indexName));
        }
        for (SearchIndexInfo indexInfo : indexInfos) {
            if (!indexInfo.getIndexName().equals(this.indexName)) continue;
            return;
        }
        throw new ClientException(String.format("Index for meta(%s) not exist: %s", this.metaTableName, this.indexName));
    }

    @Override
    public void createDataTable(String tableName) {
        TableMeta tableMeta = TableMetaGenerator.getDataTableMeta(tableName);
        TableOptions tableOptions = new TableOptions();
        tableOptions.setMaxVersions(1);
        tableOptions.setTimeToLive(-1);
        CreateTableRequest request = new CreateTableRequest(tableMeta, tableOptions);
        Future<CreateTableResponse> res = this.asyncClient.createTable(request, null);
        Utils.waitForFuture(res);
    }

    @Override
    public void deleteDataTable(String tableName) {
        DeleteTableRequest request = new DeleteTableRequest(tableName);
        Future<DeleteTableResponse> res = this.asyncClient.deleteTable(request, null);
        Utils.waitForFuture(res);
    }

    @Override
    public synchronized TimestreamDataTable dataTable(String tableName) {
        this.tryInitMetaWriter();
        TimestreamDataTable dataTable = this.dataTableMap.get(tableName);
        if (dataTable == null) {
            if (this.dataTableMap.size() >= this.config.getMaxDataTableNumForWrite()) {
                throw new ClientException("Number of data table for writen in db cannot be larger than " + this.config.getMaxDataTableNumForWrite());
            }
            DefaultTableStoreWriter writer = new DefaultTableStoreWriter(this.asyncClient, tableName, this.writerConfig, this.callback, this.executor);
            dataTable = new TimestreamDataTable(this.asyncClient, tableName, this.metaTableName, this.indexName, writer, this.metaCacheManager);
            this.dataTableMap.put(tableName, dataTable);
        }
        return dataTable;
    }

    @Override
    public TimestreamMetaTable metaTable() {
        this.tryInitMetaWriter();
        TimestreamMetaTable metaTable = new TimestreamMetaTable(this.asyncClient, this.metaTableName, this.indexName, this.metaCacheManager);
        return metaTable;
    }
}

