/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.timestream.model;

import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.model.ColumnValue;
import com.alicloud.openservices.tablestore.model.Row;
import com.alicloud.openservices.tablestore.timestream.internal.Utils;
import com.alicloud.openservices.tablestore.timestream.model.Location;
import com.alicloud.openservices.tablestore.timestream.model.TimestreamIdentifier;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class TimestreamMeta {
    private TimestreamIdentifier identifier;
    private long updateTime;
    private Map<String, ColumnValue> attributes = new TreeMap<String, ColumnValue>();

    public TimestreamMeta(TimestreamIdentifier identifier) {
        this.identifier = identifier;
        this.updateTime = TimeUnit.MILLISECONDS.toMicros(System.currentTimeMillis());
    }

    protected static TimestreamMeta newInstance(Row row) {
        return Utils.deserializeTimestreamMeta(row);
    }

    public TimestreamIdentifier getIdentifier() {
        return this.identifier;
    }

    public TimestreamMeta setUpdateTime(long timestamp, TimeUnit unit) {
        this.updateTime = unit.toMicros(timestamp);
        return this;
    }

    public long getUpdateTimeInUsec() {
        return this.updateTime;
    }

    private void checkKeyParams(String key) {
        if (key.equals("s")) {
            throw new ClientException("Key of attribute cannot be s.");
        }
    }

    public TimestreamMeta setAttributes(TreeMap<String, ColumnValue> attributes) {
        for (String key : attributes.keySet()) {
            this.checkKeyParams(key);
        }
        this.attributes = attributes;
        return this;
    }

    public TimestreamMeta addAttribute(String name, ColumnValue value) {
        this.checkKeyParams(name);
        this.attributes.put(name, value);
        return this;
    }

    public TimestreamMeta addAttribute(String name, Location value) {
        this.checkKeyParams(name);
        this.attributes.put(name, ColumnValue.fromString(value.toString()));
        return this;
    }

    public TimestreamMeta addAttribute(String name, String value) {
        this.checkKeyParams(name);
        this.attributes.put(name, ColumnValue.fromString(value));
        return this;
    }

    public TimestreamMeta addAttribute(String name, long value) {
        this.checkKeyParams(name);
        this.attributes.put(name, ColumnValue.fromLong(value));
        return this;
    }

    public TimestreamMeta addAttribute(String name, byte[] value) {
        this.checkKeyParams(name);
        this.attributes.put(name, ColumnValue.fromBinary(value));
        return this;
    }

    public TimestreamMeta addAttribute(String name, double value) {
        this.checkKeyParams(name);
        this.attributes.put(name, ColumnValue.fromDouble(value));
        return this;
    }

    public TimestreamMeta addAttribute(String name, boolean value) {
        this.checkKeyParams(name);
        this.attributes.put(name, ColumnValue.fromBoolean(value));
        return this;
    }

    public Map<String, ColumnValue> getAttributes() {
        return this.attributes;
    }

    public String getAttributeAsString(String name) {
        return this.attributes.get(name).asString();
    }

    public long getAttributeAsLong(String name) {
        return this.attributes.get(name).asLong();
    }

    public byte[] getAttributeAsBinary(String name) {
        return this.attributes.get(name).asBinary();
    }

    public double getAttributeAsDouble(String name) {
        return this.attributes.get(name).asDouble();
    }

    public boolean getAttributeAsBoolean(String name) {
        return this.attributes.get(name).asBoolean();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.identifier.toString());
        for (String name : this.attributes.keySet()) {
            sb.append(", ");
            sb.append(name);
            sb.append("=");
            sb.append(this.attributes.get(name));
        }
        sb.append(", updateTime=").append(this.updateTime);
        return sb.toString();
    }
}

