/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.core.http;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpResponse;

public class ResponseMessage {
    private HttpResponse response;
    private Map<String, String> headers;
    private static final int HTTP_SUCCESS_STATUS_CODE = 200;

    public ResponseMessage(HttpResponse response) {
        this.response = response;
    }

    public int getStatusCode() {
        return this.response.getStatusLine().getStatusCode();
    }

    public String getHeader(String header) {
        this.initHeaderMap();
        return this.headers.get(header);
    }

    public Map<String, String> getHeadersMap() {
        this.initHeaderMap();
        return this.headers;
    }

    public HttpResponse getResponse() {
        return this.response;
    }

    private void initHeaderMap() {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>(this.response.getAllHeaders().length);
            for (Header header : this.response.getAllHeaders()) {
                this.headers.put(header.getName(), header.getValue());
            }
        }
    }

    public boolean isSuccessful() {
        return this.getStatusCode() / 100 == 2;
    }

    public InputStream getContent() throws IOException {
        return this.response.getEntity().getContent();
    }

    public void close() throws IOException {
        this.response.getEntity().getContent().close();
    }
}

