/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore;

import com.alicloud.openservices.tablestore.ClientConfiguration;
import com.alicloud.openservices.tablestore.TableStoreCallback;
import com.alicloud.openservices.tablestore.core.AbortTransactionLauncher;
import com.alicloud.openservices.tablestore.core.AddDefinedColumnLauncher;
import com.alicloud.openservices.tablestore.core.AsyncBatchGetRowCompletion;
import com.alicloud.openservices.tablestore.core.AsyncCompletion;
import com.alicloud.openservices.tablestore.core.AsyncGetRangeCompletion;
import com.alicloud.openservices.tablestore.core.AsyncGetRowCompletion;
import com.alicloud.openservices.tablestore.core.BatchGetRowLauncher;
import com.alicloud.openservices.tablestore.core.BatchWriteRowLauncher;
import com.alicloud.openservices.tablestore.core.BulkExportLauncher;
import com.alicloud.openservices.tablestore.core.BulkImportLauncher;
import com.alicloud.openservices.tablestore.core.CallbackImpledFuture;
import com.alicloud.openservices.tablestore.core.CheckpointLauncher;
import com.alicloud.openservices.tablestore.core.CommitTransactionLauncher;
import com.alicloud.openservices.tablestore.core.ComputeSplitsBySizeLauncher;
import com.alicloud.openservices.tablestore.core.ComputeSplitsLauncher;
import com.alicloud.openservices.tablestore.core.ConnectTunnelLauncher;
import com.alicloud.openservices.tablestore.core.Constants;
import com.alicloud.openservices.tablestore.core.CreateIndexLauncher;
import com.alicloud.openservices.tablestore.core.CreateSearchIndexLauncher;
import com.alicloud.openservices.tablestore.core.CreateTableLauncher;
import com.alicloud.openservices.tablestore.core.CreateTunnelLauncher;
import com.alicloud.openservices.tablestore.core.DeleteDefinedColumnLauncher;
import com.alicloud.openservices.tablestore.core.DeleteIndexLauncher;
import com.alicloud.openservices.tablestore.core.DeleteRowLauncher;
import com.alicloud.openservices.tablestore.core.DeleteSearchIndexLauncher;
import com.alicloud.openservices.tablestore.core.DeleteTableLauncher;
import com.alicloud.openservices.tablestore.core.DeleteTunnelLauncher;
import com.alicloud.openservices.tablestore.core.DescribeSearchIndexLauncher;
import com.alicloud.openservices.tablestore.core.DescribeStreamLauncher;
import com.alicloud.openservices.tablestore.core.DescribeTableLauncher;
import com.alicloud.openservices.tablestore.core.DescribeTunnelLauncher;
import com.alicloud.openservices.tablestore.core.GetCheckpointLauncher;
import com.alicloud.openservices.tablestore.core.GetRangeLauncher;
import com.alicloud.openservices.tablestore.core.GetRowLauncher;
import com.alicloud.openservices.tablestore.core.GetShardIteratorLauncher;
import com.alicloud.openservices.tablestore.core.GetStreamRecordLauncher;
import com.alicloud.openservices.tablestore.core.HeartbeatLauncher;
import com.alicloud.openservices.tablestore.core.LauncherFactory;
import com.alicloud.openservices.tablestore.core.ListSearchIndexLauncher;
import com.alicloud.openservices.tablestore.core.ListStreamLauncher;
import com.alicloud.openservices.tablestore.core.ListTableLauncher;
import com.alicloud.openservices.tablestore.core.ListTunnelLauncher;
import com.alicloud.openservices.tablestore.core.OperationLauncher;
import com.alicloud.openservices.tablestore.core.ParallelScanLauncher;
import com.alicloud.openservices.tablestore.core.PutRowLauncher;
import com.alicloud.openservices.tablestore.core.ReadRecordsLauncher;
import com.alicloud.openservices.tablestore.core.SearchLauncher;
import com.alicloud.openservices.tablestore.core.ShutdownTunnelLauncher;
import com.alicloud.openservices.tablestore.core.StartLocalTransactionLauncher;
import com.alicloud.openservices.tablestore.core.TraceLogger;
import com.alicloud.openservices.tablestore.core.UpdateRowLauncher;
import com.alicloud.openservices.tablestore.core.UpdateTableLauncher;
import com.alicloud.openservices.tablestore.core.auth.CredentialsProvider;
import com.alicloud.openservices.tablestore.core.auth.CredentialsProviderFactory;
import com.alicloud.openservices.tablestore.core.auth.DefaultCredentialProvider;
import com.alicloud.openservices.tablestore.core.auth.ServiceCredentials;
import com.alicloud.openservices.tablestore.core.http.AsyncServiceClient;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.AbortTransactionRequest;
import com.alicloud.openservices.tablestore.model.AbortTransactionResponse;
import com.alicloud.openservices.tablestore.model.AddDefinedColumnRequest;
import com.alicloud.openservices.tablestore.model.AddDefinedColumnResponse;
import com.alicloud.openservices.tablestore.model.BatchGetRowRequest;
import com.alicloud.openservices.tablestore.model.BatchGetRowResponse;
import com.alicloud.openservices.tablestore.model.BatchWriteRowRequest;
import com.alicloud.openservices.tablestore.model.BatchWriteRowResponse;
import com.alicloud.openservices.tablestore.model.BulkExportRequest;
import com.alicloud.openservices.tablestore.model.BulkExportResponse;
import com.alicloud.openservices.tablestore.model.BulkImportRequest;
import com.alicloud.openservices.tablestore.model.BulkImportResponse;
import com.alicloud.openservices.tablestore.model.CommitTransactionRequest;
import com.alicloud.openservices.tablestore.model.CommitTransactionResponse;
import com.alicloud.openservices.tablestore.model.ComputeSplitsBySizeRequest;
import com.alicloud.openservices.tablestore.model.ComputeSplitsBySizeResponse;
import com.alicloud.openservices.tablestore.model.ComputeSplitsRequest;
import com.alicloud.openservices.tablestore.model.ComputeSplitsResponse;
import com.alicloud.openservices.tablestore.model.CreateIndexRequest;
import com.alicloud.openservices.tablestore.model.CreateIndexResponse;
import com.alicloud.openservices.tablestore.model.CreateTableRequest;
import com.alicloud.openservices.tablestore.model.CreateTableResponse;
import com.alicloud.openservices.tablestore.model.DeleteDefinedColumnRequest;
import com.alicloud.openservices.tablestore.model.DeleteDefinedColumnResponse;
import com.alicloud.openservices.tablestore.model.DeleteIndexRequest;
import com.alicloud.openservices.tablestore.model.DeleteIndexResponse;
import com.alicloud.openservices.tablestore.model.DeleteRowRequest;
import com.alicloud.openservices.tablestore.model.DeleteRowResponse;
import com.alicloud.openservices.tablestore.model.DeleteTableRequest;
import com.alicloud.openservices.tablestore.model.DeleteTableResponse;
import com.alicloud.openservices.tablestore.model.DescribeStreamRequest;
import com.alicloud.openservices.tablestore.model.DescribeStreamResponse;
import com.alicloud.openservices.tablestore.model.DescribeTableRequest;
import com.alicloud.openservices.tablestore.model.DescribeTableResponse;
import com.alicloud.openservices.tablestore.model.GetRangeRequest;
import com.alicloud.openservices.tablestore.model.GetRangeResponse;
import com.alicloud.openservices.tablestore.model.GetRowRequest;
import com.alicloud.openservices.tablestore.model.GetRowResponse;
import com.alicloud.openservices.tablestore.model.GetShardIteratorRequest;
import com.alicloud.openservices.tablestore.model.GetShardIteratorResponse;
import com.alicloud.openservices.tablestore.model.GetStreamRecordRequest;
import com.alicloud.openservices.tablestore.model.GetStreamRecordResponse;
import com.alicloud.openservices.tablestore.model.ListStreamRequest;
import com.alicloud.openservices.tablestore.model.ListStreamResponse;
import com.alicloud.openservices.tablestore.model.ListTableRequest;
import com.alicloud.openservices.tablestore.model.ListTableResponse;
import com.alicloud.openservices.tablestore.model.PutRowRequest;
import com.alicloud.openservices.tablestore.model.PutRowResponse;
import com.alicloud.openservices.tablestore.model.RetryStrategy;
import com.alicloud.openservices.tablestore.model.StartLocalTransactionRequest;
import com.alicloud.openservices.tablestore.model.StartLocalTransactionResponse;
import com.alicloud.openservices.tablestore.model.UpdateRowRequest;
import com.alicloud.openservices.tablestore.model.UpdateRowResponse;
import com.alicloud.openservices.tablestore.model.UpdateTableRequest;
import com.alicloud.openservices.tablestore.model.UpdateTableResponse;
import com.alicloud.openservices.tablestore.model.search.CreateSearchIndexRequest;
import com.alicloud.openservices.tablestore.model.search.CreateSearchIndexResponse;
import com.alicloud.openservices.tablestore.model.search.DeleteSearchIndexRequest;
import com.alicloud.openservices.tablestore.model.search.DeleteSearchIndexResponse;
import com.alicloud.openservices.tablestore.model.search.DescribeSearchIndexRequest;
import com.alicloud.openservices.tablestore.model.search.DescribeSearchIndexResponse;
import com.alicloud.openservices.tablestore.model.search.ListSearchIndexRequest;
import com.alicloud.openservices.tablestore.model.search.ListSearchIndexResponse;
import com.alicloud.openservices.tablestore.model.search.ParallelScanRequest;
import com.alicloud.openservices.tablestore.model.search.ParallelScanResponse;
import com.alicloud.openservices.tablestore.model.search.SearchRequest;
import com.alicloud.openservices.tablestore.model.search.SearchResponse;
import com.alicloud.openservices.tablestore.model.tunnel.CreateTunnelRequest;
import com.alicloud.openservices.tablestore.model.tunnel.CreateTunnelResponse;
import com.alicloud.openservices.tablestore.model.tunnel.DeleteTunnelRequest;
import com.alicloud.openservices.tablestore.model.tunnel.DeleteTunnelResponse;
import com.alicloud.openservices.tablestore.model.tunnel.DescribeTunnelRequest;
import com.alicloud.openservices.tablestore.model.tunnel.DescribeTunnelResponse;
import com.alicloud.openservices.tablestore.model.tunnel.ListTunnelRequest;
import com.alicloud.openservices.tablestore.model.tunnel.ListTunnelResponse;
import com.alicloud.openservices.tablestore.model.tunnel.internal.CheckpointRequest;
import com.alicloud.openservices.tablestore.model.tunnel.internal.CheckpointResponse;
import com.alicloud.openservices.tablestore.model.tunnel.internal.ConnectTunnelRequest;
import com.alicloud.openservices.tablestore.model.tunnel.internal.ConnectTunnelResponse;
import com.alicloud.openservices.tablestore.model.tunnel.internal.GetCheckpointRequest;
import com.alicloud.openservices.tablestore.model.tunnel.internal.GetCheckpointResponse;
import com.alicloud.openservices.tablestore.model.tunnel.internal.HeartbeatRequest;
import com.alicloud.openservices.tablestore.model.tunnel.internal.HeartbeatResponse;
import com.alicloud.openservices.tablestore.model.tunnel.internal.ReadRecordsRequest;
import com.alicloud.openservices.tablestore.model.tunnel.internal.ReadRecordsResponse;
import com.alicloud.openservices.tablestore.model.tunnel.internal.ShutdownTunnelRequest;
import com.alicloud.openservices.tablestore.model.tunnel.internal.ShutdownTunnelResponse;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class InternalClient {
    private static int AVAILABLE_PROCESSORS = Runtime.getRuntime().availableProcessors();
    private String endpoint;
    private String instanceName;
    private CredentialsProvider crdsProvider;
    private AsyncServiceClient httpClient;
    private ScheduledExecutorService retryExecutor;
    private ExecutorService callbackExecutor;
    private ClientConfiguration clientConfig;
    private RetryStrategy retryStrategy;
    private LauncherFactory launcherFactory;
    private Random random = new Random();

    public InternalClient(String endpoint, String accessKeyId, String accessKeySecret, String instanceName) {
        this(endpoint, accessKeyId, accessKeySecret, instanceName, null);
    }

    public InternalClient(String endpoint, String accessKeyId, String accessKeySecret, String instanceName, ClientConfiguration config) {
        this(endpoint, accessKeyId, accessKeySecret, instanceName, config, null);
    }

    public InternalClient(String endpoint, String accessKeyId, String accessKeySecret, String instanceName, ClientConfiguration config, ExecutorService callbackExecutor) {
        this(endpoint, accessKeyId, accessKeySecret, instanceName, config, callbackExecutor, null);
    }

    public InternalClient(String endpoint, String accessKeyId, String accessKeySecret, String instanceName, ClientConfiguration config, ExecutorService callbackExecutor, String stsToken) {
        this(endpoint, CredentialsProviderFactory.newDefaultCredentialProvider(accessKeyId, accessKeySecret, stsToken), instanceName, config, callbackExecutor);
    }

    public InternalClient(String endpoint, CredentialsProvider credsProvider, String instanceName, ClientConfiguration config, ExecutorService callbackExecutor) {
        Preconditions.checkArgument(endpoint != null && !endpoint.isEmpty(), "The end point should not be null or empty.");
        Preconditions.checkArgument(instanceName != null && !instanceName.isEmpty(), "The name of instance should not be null or empty.");
        Preconditions.checkArgument(instanceName.length() == instanceName.getBytes(Constants.UTF8_CHARSET).length, "InstanceName should not have multibyte character.");
        if (!endpoint.startsWith("http://") && !endpoint.startsWith("https://")) {
            throw new IllegalArgumentException("the endpoint must start with \"http://\" or \"https://\".");
        }
        this.endpoint = endpoint;
        this.crdsProvider = credsProvider;
        if (config == null) {
            config = new ClientConfiguration();
        }
        this.clientConfig = config;
        this.httpClient = new AsyncServiceClient(config);
        this.retryExecutor = Executors.newScheduledThreadPool(config.getRetryThreadCount(), new ThreadFactory(){
            private final AtomicInteger counter = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "tablestore-retry-scheduled-" + this.counter.getAndIncrement());
            }
        });
        this.retryStrategy = config.getRetryStrategy();
        this.instanceName = instanceName;
        this.callbackExecutor = callbackExecutor != null ? callbackExecutor : Executors.newFixedThreadPool(AVAILABLE_PROCESSORS, new ThreadFactory(){
            private final AtomicInteger counter = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "tablestore-callback-" + this.counter.getAndIncrement());
            }
        });
        this.launcherFactory = new LauncherFactory(endpoint, instanceName, this.httpClient, this.crdsProvider, config);
    }

    public void setExtraHeaders(Map<String, String> extraHeaders) {
        this.httpClient.setExtraHeaders(extraHeaders);
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public ClientConfiguration getClientConfig() {
        return this.clientConfig;
    }

    private TraceLogger getTraceLogger() {
        String traceId = new UUID(this.random.nextLong(), new Random().nextLong()).toString();
        return new TraceLogger(traceId, this.clientConfig.getTimeThresholdOfTraceLogger());
    }

    public Future<ListTableResponse> listTable(TableStoreCallback<ListTableRequest, ListTableResponse> callback) {
        ListTableRequest request = new ListTableRequest();
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        ListTableLauncher launcher = this.launcherFactory.listTable(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, completion);
        return f;
    }

    public Future<CreateTableResponse> createTable(CreateTableRequest request, TableStoreCallback<CreateTableRequest, CreateTableResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        CreateTableLauncher launcher = this.launcherFactory.createTable(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, completion);
        return f;
    }

    public Future<DescribeTableResponse> describeTable(DescribeTableRequest request, TableStoreCallback<DescribeTableRequest, DescribeTableResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        DescribeTableLauncher launcher = this.launcherFactory.describeTable(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, completion);
        return f;
    }

    public Future<DeleteTableResponse> deleteTable(DeleteTableRequest request, TableStoreCallback<DeleteTableRequest, DeleteTableResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        DeleteTableLauncher launcher = this.launcherFactory.deleteTable(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, completion);
        return f;
    }

    public Future<UpdateTableResponse> updateTable(UpdateTableRequest request, TableStoreCallback<UpdateTableRequest, UpdateTableResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        UpdateTableLauncher launcher = this.launcherFactory.updateTable(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, completion);
        return f;
    }

    public Future<CreateIndexResponse> createIndex(CreateIndexRequest request, TableStoreCallback<CreateIndexRequest, CreateIndexResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        CreateIndexLauncher launcher = this.launcherFactory.createIndex(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, completion);
        return f;
    }

    public Future<DeleteIndexResponse> deleteIndex(DeleteIndexRequest request, TableStoreCallback<DeleteIndexRequest, DeleteIndexResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        DeleteIndexLauncher launcher = this.launcherFactory.deleteIndex(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, completion);
        return f;
    }

    public Future<AddDefinedColumnResponse> addDefinedColumn(AddDefinedColumnRequest request, TableStoreCallback<AddDefinedColumnRequest, AddDefinedColumnResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        AddDefinedColumnLauncher launcher = this.launcherFactory.addDefinedColumn(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, completion);
        return f;
    }

    public Future<DeleteDefinedColumnResponse> deleteDefinedColumn(DeleteDefinedColumnRequest request, TableStoreCallback<DeleteDefinedColumnRequest, DeleteDefinedColumnResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        DeleteDefinedColumnLauncher launcher = this.launcherFactory.deleteDefinedColumn(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, completion);
        return f;
    }

    public Future<GetRowResponse> getRowInternal(GetRowRequest request, TableStoreCallback<GetRowRequest, GetRowResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        GetRowLauncher launcher = this.launcherFactory.getRow(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, completion);
        return f;
    }

    public Future<GetRowResponse> getRow(GetRowRequest request, TableStoreCallback<GetRowRequest, GetRowResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        GetRowLauncher launcher = this.launcherFactory.getRow(tracer, retry, request);
        AsyncGetRowCompletion completion = new AsyncGetRowCompletion((OperationLauncher<GetRowRequest, GetRowResponse>)launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, completion);
        return f;
    }

    public Future<PutRowResponse> putRow(PutRowRequest request, TableStoreCallback<PutRowRequest, PutRowResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        PutRowLauncher launcher = this.launcherFactory.putRow(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, completion);
        return f;
    }

    public Future<UpdateRowResponse> updateRow(UpdateRowRequest request, TableStoreCallback<UpdateRowRequest, UpdateRowResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        UpdateRowLauncher launcher = this.launcherFactory.updateRow(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, completion);
        return f;
    }

    public Future<DeleteRowResponse> deleteRow(DeleteRowRequest request, TableStoreCallback<DeleteRowRequest, DeleteRowResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        DeleteRowLauncher launcher = this.launcherFactory.deleteRow(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, completion);
        return f;
    }

    public Future<BatchGetRowResponse> batchGetRowInternal(BatchGetRowRequest request, TableStoreCallback<BatchGetRowRequest, BatchGetRowResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        BatchGetRowLauncher launcher = this.launcherFactory.batchGetRow(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, completion);
        return f;
    }

    public Future<BatchGetRowResponse> batchGetRow(BatchGetRowRequest request, TableStoreCallback<BatchGetRowRequest, BatchGetRowResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        BatchGetRowLauncher launcher = this.launcherFactory.batchGetRow(tracer, retry, request);
        AsyncBatchGetRowCompletion completion = new AsyncBatchGetRowCompletion((OperationLauncher)launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, completion);
        return f;
    }

    public Future<BatchWriteRowResponse> batchWriteRow(BatchWriteRowRequest request, TableStoreCallback<BatchWriteRowRequest, BatchWriteRowResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        BatchWriteRowLauncher launcher = this.launcherFactory.batchWriteRow(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, completion);
        return f;
    }

    public Future<BulkImportResponse> bulkImport(BulkImportRequest request, TableStoreCallback<BulkImportRequest, BulkImportResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        BulkImportLauncher launcher = this.launcherFactory.bulkImport(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, completion);
        return f;
    }

    public Future<GetRangeResponse> getRangeInternal(GetRangeRequest request, TableStoreCallback<GetRangeRequest, GetRangeResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        GetRangeLauncher launcher = this.launcherFactory.getRange(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, completion);
        return f;
    }

    public Future<BulkExportResponse> bulkExportInternal(BulkExportRequest request, TableStoreCallback<BulkExportRequest, BulkExportResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        BulkExportLauncher launcher = this.launcherFactory.bulkExport(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, completion);
        return f;
    }

    public Future<GetRangeResponse> getRange(GetRangeRequest request, TableStoreCallback<GetRangeRequest, GetRangeResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        GetRangeLauncher launcher = this.launcherFactory.getRange(tracer, retry, request);
        AsyncGetRangeCompletion completion = new AsyncGetRangeCompletion((OperationLauncher<GetRangeRequest, GetRangeResponse>)launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, completion);
        return f;
    }

    public Future<BulkExportResponse> bulkExport(BulkExportRequest request, TableStoreCallback<BulkExportRequest, BulkExportResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        BulkExportLauncher launcher = this.launcherFactory.bulkExport(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, completion);
        return f;
    }

    public Future<ComputeSplitsBySizeResponse> computeSplitsBySize(ComputeSplitsBySizeRequest request, TableStoreCallback<ComputeSplitsBySizeRequest, ComputeSplitsBySizeResponse> callback) {
        Preconditions.checkNotNull(request);
        Preconditions.checkStringNotNullAndEmpty(request.getTableName(), "The table name for ComputeSplitsBySize should not be null or empty.");
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        ComputeSplitsBySizeLauncher launcher = this.launcherFactory.computeSplitsBySize(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, completion);
        return f;
    }

    public void shutdown() {
        this.retryExecutor.shutdownNow();
        this.callbackExecutor.shutdownNow();
        this.httpClient.shutdown();
    }

    public Future<ListStreamResponse> listStream(ListStreamRequest request, TableStoreCallback<ListStreamRequest, ListStreamResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        ListStreamLauncher launcher = this.launcherFactory.listStream(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, completion);
        return f;
    }

    public Future<DescribeStreamResponse> describeStream(DescribeStreamRequest request, TableStoreCallback<DescribeStreamRequest, DescribeStreamResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        DescribeStreamLauncher launcher = this.launcherFactory.describeStream(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, completion);
        return f;
    }

    public Future<GetShardIteratorResponse> getShardIterator(GetShardIteratorRequest request, TableStoreCallback<GetShardIteratorRequest, GetShardIteratorResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        GetShardIteratorLauncher launcher = this.launcherFactory.getShardIterator(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, completion);
        return f;
    }

    public Future<GetStreamRecordResponse> getStreamRecord(GetStreamRecordRequest request, TableStoreCallback<GetStreamRecordRequest, GetStreamRecordResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        GetStreamRecordLauncher launcher = this.launcherFactory.getStreamRecord(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, completion);
        return f;
    }

    public Future<StartLocalTransactionResponse> startLocalTransaction(StartLocalTransactionRequest request, TableStoreCallback<StartLocalTransactionRequest, StartLocalTransactionResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        StartLocalTransactionLauncher launcher = this.launcherFactory.startLocalTransaction(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, completion);
        return f;
    }

    public Future<CommitTransactionResponse> commitTransaction(CommitTransactionRequest request, TableStoreCallback<CommitTransactionRequest, CommitTransactionResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        CommitTransactionLauncher launcher = this.launcherFactory.commitTransaction(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, completion);
        return f;
    }

    public Future<AbortTransactionResponse> abortTransaction(AbortTransactionRequest request, TableStoreCallback<AbortTransactionRequest, AbortTransactionResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        AbortTransactionLauncher launcher = this.launcherFactory.abortTransaction(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, completion);
        return f;
    }

    public Future<CreateSearchIndexResponse> createSearchIndex(CreateSearchIndexRequest request, TableStoreCallback<CreateSearchIndexRequest, CreateSearchIndexResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        CreateSearchIndexLauncher launcher = this.launcherFactory.createSearchIndex(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, completion);
        return f;
    }

    public Future<ListSearchIndexResponse> listSearchIndex(ListSearchIndexRequest request, TableStoreCallback<ListSearchIndexRequest, ListSearchIndexResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        ListSearchIndexLauncher launcher = this.launcherFactory.listSearchIndex(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, completion);
        return f;
    }

    public Future<DeleteSearchIndexResponse> deleteSearchIndex(DeleteSearchIndexRequest request, TableStoreCallback<DeleteSearchIndexRequest, DeleteSearchIndexResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        DeleteSearchIndexLauncher launcher = this.launcherFactory.deleteSearchIndex(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, completion);
        return f;
    }

    public Future<DescribeSearchIndexResponse> describeSearchIndex(DescribeSearchIndexRequest request, TableStoreCallback<DescribeSearchIndexRequest, DescribeSearchIndexResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        DescribeSearchIndexLauncher launcher = this.launcherFactory.describeSearchIndex(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, completion);
        return f;
    }

    public Future<ComputeSplitsResponse> computeSplits(ComputeSplitsRequest request, TableStoreCallback<ComputeSplitsRequest, ComputeSplitsResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        ComputeSplitsLauncher launcher = this.launcherFactory.computeSplits(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, completion);
        return f;
    }

    public Future<ParallelScanResponse> parallelScan(ParallelScanRequest request, TableStoreCallback<ParallelScanRequest, ParallelScanResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        ParallelScanLauncher launcher = this.launcherFactory.parallelScan(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, completion);
        return f;
    }

    public Future<SearchResponse> search(SearchRequest request, TableStoreCallback<SearchRequest, SearchResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        SearchLauncher launcher = this.launcherFactory.search(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, completion);
        return f;
    }

    public Future<CreateTunnelResponse> createTunnel(CreateTunnelRequest request, TableStoreCallback<CreateTunnelRequest, CreateTunnelResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        CreateTunnelLauncher launcher = this.launcherFactory.createTunnel(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, completion);
        return f;
    }

    public Future<ListTunnelResponse> listTunnel(ListTunnelRequest request, TableStoreCallback<ListTunnelRequest, ListTunnelResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        ListTunnelLauncher launcher = this.launcherFactory.listTunnel(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, completion);
        return f;
    }

    public Future<DescribeTunnelResponse> describeTunnel(DescribeTunnelRequest request, TableStoreCallback<DescribeTunnelRequest, DescribeTunnelResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        DescribeTunnelLauncher launcher = this.launcherFactory.describeTunnel(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, completion);
        return f;
    }

    public Future<DeleteTunnelResponse> deleteTunnel(DeleteTunnelRequest request, TableStoreCallback<DeleteTunnelRequest, DeleteTunnelResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        DeleteTunnelLauncher launcher = this.launcherFactory.deleteTunnel(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, completion);
        return f;
    }

    public Future<ConnectTunnelResponse> connectTunnel(ConnectTunnelRequest request, TableStoreCallback<ConnectTunnelRequest, ConnectTunnelResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        ConnectTunnelLauncher launcher = this.launcherFactory.connectTunnel(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, completion);
        return f;
    }

    public Future<HeartbeatResponse> heartbeat(HeartbeatRequest request, TableStoreCallback<HeartbeatRequest, HeartbeatResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        HeartbeatLauncher launcher = this.launcherFactory.heartbeat(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, completion);
        return f;
    }

    public Future<ShutdownTunnelResponse> shutdownTunnel(ShutdownTunnelRequest request, TableStoreCallback<ShutdownTunnelRequest, ShutdownTunnelResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        ShutdownTunnelLauncher launcher = this.launcherFactory.shutdownTunnel(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, completion);
        return f;
    }

    public Future<GetCheckpointResponse> getCheckpoint(GetCheckpointRequest request, TableStoreCallback<GetCheckpointRequest, GetCheckpointResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        GetCheckpointLauncher launcher = this.launcherFactory.getCheckpoint(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, completion);
        return f;
    }

    public Future<ReadRecordsResponse> readRecords(ReadRecordsRequest request, TableStoreCallback<ReadRecordsRequest, ReadRecordsResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        ReadRecordsLauncher launcher = this.launcherFactory.readRecords(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, completion);
        return f;
    }

    public Future<CheckpointResponse> checkpoint(CheckpointRequest request, TableStoreCallback<CheckpointRequest, CheckpointResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        CheckpointLauncher launcher = this.launcherFactory.checkpoint(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, completion);
        return f;
    }

    public void setCredentials(ServiceCredentials credentials) {
        DefaultCredentialProvider newCrdsProvider = CredentialsProviderFactory.newDefaultCredentialProvider(credentials.getAccessKeyId(), credentials.getAccessKeySecret(), credentials.getSecurityToken());
        this.switchCredentialsProvider(newCrdsProvider);
    }

    public void switchCredentialsProvider(CredentialsProvider newCrdsProvider) {
        this.crdsProvider = newCrdsProvider;
        this.launcherFactory.setCredentialsProvider(newCrdsProvider);
    }
}

