/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.core.protocol;

import com.alicloud.openservices.tablestore.core.protocol.Search;
import com.alicloud.openservices.tablestore.core.protocol.SearchSortBuilder;
import com.alicloud.openservices.tablestore.core.protocol.SearchVariantType;
import com.alicloud.openservices.tablestore.model.search.agg.Aggregation;
import com.alicloud.openservices.tablestore.model.search.agg.AggregationType;
import com.alicloud.openservices.tablestore.model.search.agg.AvgAggregation;
import com.alicloud.openservices.tablestore.model.search.agg.CountAggregation;
import com.alicloud.openservices.tablestore.model.search.agg.DistinctCountAggregation;
import com.alicloud.openservices.tablestore.model.search.agg.MaxAggregation;
import com.alicloud.openservices.tablestore.model.search.agg.MinAggregation;
import com.alicloud.openservices.tablestore.model.search.agg.SumAggregation;
import com.alicloud.openservices.tablestore.model.search.agg.TopRowsAggregation;
import com.google.protobuf.ByteString;
import java.util.List;

public class SearchAggregationBuilder {
    private static Search.AggregationType buildAggregationType(AggregationType type) {
        switch (type) {
            case AGG_AVG: {
                return Search.AggregationType.AGG_AVG;
            }
            case AGG_MIN: {
                return Search.AggregationType.AGG_MIN;
            }
            case AGG_MAX: {
                return Search.AggregationType.AGG_MAX;
            }
            case AGG_SUM: {
                return Search.AggregationType.AGG_SUM;
            }
            case AGG_COUNT: {
                return Search.AggregationType.AGG_COUNT;
            }
            case AGG_DISTINCT_COUNT: {
                return Search.AggregationType.AGG_DISTINCT_COUNT;
            }
            case AGG_TOP_ROWS: {
                return Search.AggregationType.AGG_TOP_ROWS;
            }
        }
        throw new IllegalArgumentException("unknown AggregationType: " + type.name());
    }

    public static Search.MaxAggregation buildMaxAggregation(MaxAggregation agg) {
        Search.MaxAggregation.Builder builder = Search.MaxAggregation.newBuilder();
        builder.setFieldName(agg.getFieldName());
        if (agg.getMissing() != null) {
            builder.setMissing(ByteString.copyFrom((byte[])SearchVariantType.toVariant(agg.getMissing())));
        }
        return builder.build();
    }

    public static Search.AvgAggregation buildAvgAggregation(AvgAggregation agg) {
        Search.AvgAggregation.Builder builder = Search.AvgAggregation.newBuilder();
        builder.setFieldName(agg.getFieldName());
        if (agg.getMissing() != null) {
            builder.setMissing(ByteString.copyFrom((byte[])SearchVariantType.toVariant(agg.getMissing())));
        }
        return builder.build();
    }

    public static Search.MinAggregation buildMinAggregation(MinAggregation agg) {
        Search.MinAggregation.Builder builder = Search.MinAggregation.newBuilder();
        builder.setFieldName(agg.getFieldName());
        if (agg.getMissing() != null) {
            builder.setMissing(ByteString.copyFrom((byte[])SearchVariantType.toVariant(agg.getMissing())));
        }
        return builder.build();
    }

    public static Search.SumAggregation buildSumAggregation(SumAggregation agg) {
        Search.SumAggregation.Builder builder = Search.SumAggregation.newBuilder();
        builder.setFieldName(agg.getFieldName());
        if (agg.getMissing() != null) {
            builder.setMissing(ByteString.copyFrom((byte[])SearchVariantType.toVariant(agg.getMissing())));
        }
        return builder.build();
    }

    public static Search.CountAggregation buildCountAggregation(CountAggregation agg) {
        Search.CountAggregation.Builder builder = Search.CountAggregation.newBuilder();
        builder.setFieldName(agg.getFieldName());
        return builder.build();
    }

    public static Search.DistinctCountAggregation buildDistinctCountAggregation(DistinctCountAggregation agg) {
        Search.DistinctCountAggregation.Builder builder = Search.DistinctCountAggregation.newBuilder();
        builder.setFieldName(agg.getFieldName());
        if (agg.getMissing() != null) {
            builder.setMissing(ByteString.copyFrom((byte[])SearchVariantType.toVariant(agg.getMissing())));
        }
        return builder.build();
    }

    public static Search.TopRowsAggregation buildTopRowsAggregation(TopRowsAggregation agg) {
        Search.TopRowsAggregation.Builder builder = Search.TopRowsAggregation.newBuilder();
        if (agg.getLimit() != null) {
            builder.setLimit(agg.getLimit());
        }
        if (agg.getSort() != null) {
            builder.setSort(SearchSortBuilder.buildSort(agg.getSort()));
        }
        return builder.build();
    }

    private static Search.Aggregation buildAggregation(Aggregation aggregation) {
        Search.Aggregation.Builder builder = Search.Aggregation.newBuilder();
        builder.setName(aggregation.getAggName());
        builder.setType(SearchAggregationBuilder.buildAggregationType(aggregation.getAggType()));
        builder.setBody(aggregation.serialize());
        return builder.build();
    }

    static Search.Aggregations buildAggregations(List<Aggregation> aggregations) {
        Search.Aggregations.Builder builder = Search.Aggregations.newBuilder();
        for (Aggregation aggregation : aggregations) {
            builder.addAggs(SearchAggregationBuilder.buildAggregation(aggregation));
        }
        return builder.build();
    }
}

