/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.ecosystem;

import com.alicloud.openservices.tablestore.model.ColumnValue;
import java.util.List;

public class Filter {
    private LogicOperator logicOperator;
    private CompareOperator compareOperator;
    private List<Filter> filters;
    private String columnName;
    private ColumnValue columnValue;

    public boolean isNested() {
        return this.filters != null && this.filters.size() > 0;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public ColumnValue getColumnValue() {
        return this.columnValue;
    }

    public List<Filter> getSubFilters() {
        return this.filters;
    }

    public LogicOperator getLogicOperator() {
        return this.logicOperator;
    }

    public CompareOperator getCompareOperator() {
        return this.compareOperator;
    }

    public Filter(LogicOperator lo, List<Filter> subFilters) {
        this.logicOperator = lo;
        this.filters = subFilters;
    }

    public Filter(CompareOperator co, String columnName, ColumnValue columnValue) {
        this.compareOperator = co;
        this.columnName = columnName;
        this.columnValue = columnValue;
    }

    public Filter(CompareOperator co) {
        this.compareOperator = co;
    }

    public static Filter emptyFilter() {
        return new Filter(CompareOperator.EMPTY_FILTER);
    }

    public void setLogicOperator(LogicOperator logicOperator) {
        this.logicOperator = logicOperator;
    }

    public void setCompareOperator(CompareOperator compareOperator) {
        this.compareOperator = compareOperator;
    }

    public void setFilters(List<Filter> filters) {
        this.filters = filters;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public void setColumnValue(ColumnValue columnValue) {
        this.columnValue = columnValue;
    }

    public static enum LogicOperator {
        NOT,
        AND,
        OR;

    }

    public static enum CompareOperator {
        EMPTY_FILTER,
        EQUAL,
        GREATER_EQUAL,
        GREATER_THAN,
        LESS_EQUAL,
        LESS_THAN,
        NOT_EQUAL,
        START_WITH;

    }
}

