/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.ecosystem;

import com.alicloud.openservices.tablestore.SyncClient;
import com.alicloud.openservices.tablestore.SyncClientInterface;
import com.alicloud.openservices.tablestore.ecosystem.CatalogManager;
import com.alicloud.openservices.tablestore.ecosystem.Filter;
import com.alicloud.openservices.tablestore.ecosystem.ICatalogManager;
import com.alicloud.openservices.tablestore.ecosystem.ITablestoreSplit;
import com.alicloud.openservices.tablestore.ecosystem.SearchInfo;
import com.alicloud.openservices.tablestore.ecosystem.TableCatalog;
import com.alicloud.openservices.tablestore.model.BatchGetRowRequest;
import com.alicloud.openservices.tablestore.model.BatchGetRowResponse;
import com.alicloud.openservices.tablestore.model.MultiRowQueryCriteria;
import com.alicloud.openservices.tablestore.model.PrimaryKey;
import com.alicloud.openservices.tablestore.model.PrimaryKeyBuilder;
import com.alicloud.openservices.tablestore.model.PrimaryKeyColumn;
import com.alicloud.openservices.tablestore.model.PrimaryKeySchema;
import com.alicloud.openservices.tablestore.model.PrimaryKeyValue;
import com.alicloud.openservices.tablestore.model.RangeIteratorParameter;
import com.alicloud.openservices.tablestore.model.Row;
import com.alicloud.openservices.tablestore.model.Split;
import com.alicloud.openservices.tablestore.model.TableMeta;
import com.alicloud.openservices.tablestore.model.search.IndexSchema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TablestoreSplit
implements ITablestoreSplit {
    private static final Logger LOG = LoggerFactory.getLogger(TablestoreSplit.class);
    private int maxFirstColumnRangeSupport = 20;
    private int maxFirstColumnEqualSupport = 10;
    private ICatalogManager manager;
    private TableMeta meta;
    private SearchInfo searchInfo;
    private String splitName;
    private String tableName;
    private SplitType type;
    private Split kvSplit;
    private Filter filter;
    private List<String> requiredColumns;

    public TablestoreSplit(SplitType type, Filter filter, List<String> requiredColumns) {
        this.type = type;
        this.filter = filter;
        this.requiredColumns = requiredColumns;
    }

    public void setSplitName(String name) {
        this.splitName = name;
    }

    public List<String> getRequiredColumns() {
        return this.requiredColumns;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setKvSplit(Split split) {
        this.kvSplit = split;
    }

    public void setSearchInfo(SearchInfo info) {
        this.searchInfo = info;
    }

    public void setKvTableMeta(TableMeta meta) {
        this.meta = meta;
    }

    @Override
    public Iterator<Row> getRowIterator(SyncClientInterface client) {
        if (this.type == SplitType.KeyValue) {
            return this.generateTableIterator(client);
        }
        return this.generateSearchIndexIterator(client);
    }

    private Iterator<Row> generateTableIterator(SyncClientInterface client) {
        List<PkRange> pkRanges = this.generatePkRange(this.filter, this.kvSplit.getLowerBound(), this.kvSplit.getUpperBound());
        if (this.checkIsBatchRead(pkRanges)) {
            LOG.debug("Batch get row");
            BatchGetRowRequest request = this.buildBatchGet(pkRanges);
            BatchGetRowResponse response = client.batchGetRow(request);
            if (response.getFailedRows().isEmpty()) {
                ArrayList<Row> rowCollction = new ArrayList<Row>();
                for (BatchGetRowResponse.RowResult result : response.getSucceedRows()) {
                    if (result.getRow() == null) continue;
                    rowCollction.add(result.getRow());
                }
                return rowCollction.iterator();
            }
        } else if (pkRanges.size() == 1) {
            LOG.debug("Generate sub range to scan");
            PkRange range = pkRanges.get(0);
            return this.generateIterator(client, range.begin, range.end);
        }
        LOG.debug("Scan the whole split");
        return this.generateIterator(client, this.kvSplit.getLowerBound(), this.kvSplit.getUpperBound());
    }

    private boolean checkIsBatchRead(List<PkRange> pkRanges) {
        if (pkRanges.size() >= 1 && pkRanges.size() <= 100) {
            for (PkRange range : pkRanges) {
                if (range.equal != null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private BatchGetRowRequest buildBatchGet(List<PkRange> pkRanges) {
        BatchGetRowRequest request = new BatchGetRowRequest();
        MultiRowQueryCriteria criteria1 = new MultiRowQueryCriteria(this.tableName);
        criteria1.setMaxVersions(1);
        for (PkRange range : pkRanges) {
            criteria1.addRow(range.equal);
            request.addMultiRowQueryCriteria(criteria1);
        }
        return request;
    }

    private Iterator<Row> generateSearchIndexIterator(SyncClientInterface client) {
        return null;
    }

    private Iterator<Row> generateIterator(SyncClientInterface client, PrimaryKey begin, PrimaryKey end) {
        RangeIteratorParameter rangeIteratorParameter = new RangeIteratorParameter(this.meta.getTableName());
        rangeIteratorParameter.setInclusiveStartPrimaryKey(begin);
        rangeIteratorParameter.setExclusiveEndPrimaryKey(end);
        rangeIteratorParameter.setMaxVersions(1);
        if (this.requiredColumns != null && !this.requiredColumns.isEmpty()) {
            for (String col : this.requiredColumns) {
                rangeIteratorParameter.addColumnsToGet(col);
            }
        } else {
            String defaultString = begin.getPrimaryKeyColumn(0).getName();
            rangeIteratorParameter.addColumnsToGet(defaultString);
        }
        Iterator<Row> iterator = client.createRangeIterator(rangeIteratorParameter);
        return iterator;
    }

    private List<Range> generateColumnRange(Filter filter, PrimaryKey begin, PrimaryKey end, int starPos) {
        String name = this.meta.getPrimaryKeyList().get(starPos).getName();
        if (filter.isNested()) {
            if (filter.getLogicOperator() == Filter.LogicOperator.AND || filter.getLogicOperator() == Filter.LogicOperator.OR) {
                List<Range> mergedResult = new ArrayList<Range>();
                for (Filter subFilter : filter.getSubFilters()) {
                    List<Range> result = this.generateColumnRange(subFilter, begin, end, starPos);
                    if (mergedResult.isEmpty() && result != null && !result.isEmpty()) {
                        mergedResult = result;
                        continue;
                    }
                    if (filter.getLogicOperator() == Filter.LogicOperator.AND) {
                        if (result != null && !result.isEmpty()) {
                            mergedResult = this.mergeSubRange(mergedResult, result, begin, end);
                        }
                        if (result != null) continue;
                        return new ArrayList<Range>();
                    }
                    if (result == null || result.isEmpty()) continue;
                    mergedResult = this.mergeTotalRange(mergedResult, result, begin, end);
                }
                return mergedResult;
            }
            PrimaryKeyColumn col1 = new PrimaryKeyColumn(name, begin.getPrimaryKeyColumn(starPos).getValue());
            PrimaryKeyColumn col2 = new PrimaryKeyColumn(name, end.getPrimaryKeyColumn(starPos).getValue());
            Range range = new Range(col1, col2);
            return Arrays.asList(range);
        }
        ArrayList<Range> result = new ArrayList<Range>();
        if (filter != null && filter.getColumnName() != null && filter.getColumnName().equals(name)) {
            PrimaryKeyValue pkv = PrimaryKeyValue.fromColumn(filter.getColumnValue());
            if (filter.getCompareOperator() == Filter.CompareOperator.EQUAL) {
                PrimaryKeyColumn pkc = new PrimaryKeyColumn(name, PrimaryKeyValue.fromColumn(filter.getColumnValue()));
                Range range = new Range(pkc);
                result.add(range);
            } else if (filter.getCompareOperator() == Filter.CompareOperator.LESS_THAN || filter.getCompareOperator() == Filter.CompareOperator.LESS_EQUAL) {
                if (starPos == 0) {
                    if (pkv.compareTo(end.getPrimaryKeyColumn(starPos).getValue()) >= 0) {
                        PrimaryKeyColumn pkc1 = new PrimaryKeyColumn(name, begin.getPrimaryKeyColumn(starPos).getValue());
                        PrimaryKeyColumn pkc2 = new PrimaryKeyColumn(name, end.getPrimaryKeyColumn(starPos).getValue());
                        Range range = new Range(pkc1, pkc2);
                        result.add(range);
                    } else if (pkv.compareTo(begin.getPrimaryKeyColumn(starPos).getValue()) >= 0) {
                        PrimaryKeyColumn pkc1 = new PrimaryKeyColumn(name, begin.getPrimaryKeyColumn(starPos).getValue());
                        PrimaryKeyColumn pkc2 = new PrimaryKeyColumn(name, pkv);
                        Range range = new Range(pkc1, pkc2);
                        result.add(range);
                    } else {
                        LOG.info("find empty split", (Object)begin.toString(), (Object)end.toString());
                    }
                } else {
                    PrimaryKeyColumn pkc1 = new PrimaryKeyColumn(name, PrimaryKeyValue.INF_MIN);
                    PrimaryKeyColumn pkc2 = new PrimaryKeyColumn(name, pkv);
                    Range range = new Range(pkc1, pkc2);
                    result.add(range);
                }
            } else if (filter.getCompareOperator() == Filter.CompareOperator.GREATER_EQUAL || filter.getCompareOperator() == Filter.CompareOperator.GREATER_THAN) {
                if (starPos == 0) {
                    if (pkv.compareTo(begin.getPrimaryKeyColumn(starPos).getValue()) < 0) {
                        PrimaryKeyColumn pkc1 = new PrimaryKeyColumn(name, begin.getPrimaryKeyColumn(starPos).getValue());
                        PrimaryKeyColumn pkc2 = new PrimaryKeyColumn(name, end.getPrimaryKeyColumn(starPos).getValue());
                        Range range = new Range(pkc1, pkc2);
                        result.add(range);
                    } else if (pkv.compareTo(end.getPrimaryKeyColumn(starPos).getValue()) <= 0) {
                        PrimaryKeyColumn pkc1 = new PrimaryKeyColumn(name, pkv);
                        PrimaryKeyColumn pkc2 = new PrimaryKeyColumn(name, end.getPrimaryKeyColumn(starPos).getValue());
                        Range range = new Range(pkc1, pkc2);
                        result.add(range);
                    }
                } else {
                    PrimaryKeyColumn pkc1 = new PrimaryKeyColumn(name, pkv);
                    PrimaryKeyColumn pkc2 = new PrimaryKeyColumn(name, PrimaryKeyValue.INF_MAX);
                    Range range = new Range(pkc1, pkc2);
                    result.add(range);
                }
            }
        }
        return result;
    }

    private List<PkRange> generatePkRange(Filter filter, PrimaryKey begin, PrimaryKey end) {
        ArrayList<PkRange> pkList = new ArrayList<PkRange>();
        List<Range> first = this.generateColumnRange(filter, begin, end, 0);
        boolean isRange = false;
        if (first.size() > this.maxFirstColumnEqualSupport && first.size() <= this.maxFirstColumnRangeSupport) {
            isRange = true;
        } else {
            if (first.size() > this.maxFirstColumnRangeSupport) {
                PkRange pkRange = new PkRange(begin, end);
                pkList.add(pkRange);
                return pkList;
            }
            isRange = this.checkHasRange(first);
        }
        if (isRange) {
            return this.buildPkRangeFromRange(first);
        }
        for (int i = 1; i < this.meta.getPrimaryKeyList().size(); ++i) {
            List<Range> subRange = this.generateColumnRange(filter, begin, end, 1);
            if (this.checkHasRange(subRange) || i == this.meta.getPrimaryKeyList().size() - 1 || subRange.isEmpty()) {
                first = this.appendRange(first, subRange);
                return this.buildPkRangeFromRange(first);
            }
            first = this.appendRange(first, subRange);
        }
        return pkList;
    }

    private List<Range> appendRange(List<Range> rangeList1, List<Range> rangeList2) {
        ArrayList<Range> rangeList = new ArrayList<Range>();
        for (Range front : rangeList1) {
            if (rangeList2.isEmpty()) {
                Range temp = new Range(front);
                rangeList.add(temp);
                continue;
            }
            for (Range back : rangeList2) {
                Range temp = new Range(front);
                temp.next = back;
                rangeList.add(temp);
            }
        }
        return rangeList;
    }

    private List<PkRange> buildPkRangeFromRange(List<Range> rangeList) {
        ArrayList<PkRange> pkList = new ArrayList<PkRange>();
        for (Range range : rangeList) {
            PkRange pkRange;
            PrimaryKeyBuilder pkb = PrimaryKeyBuilder.createPrimaryKeyBuilder();
            PrimaryKeyBuilder pkb2 = PrimaryKeyBuilder.createPrimaryKeyBuilder();
            boolean isRange = false;
            if (range.equal != null) {
                pkb.addPrimaryKeyColumn(range.equal.getName(), range.equal.getValue());
                pkb2.addPrimaryKeyColumn(range.equal.getName(), range.equal.getValue());
            } else {
                isRange = true;
                pkb.addPrimaryKeyColumn(range.begin.getName(), range.begin.getValue());
                pkb2.addPrimaryKeyColumn(range.end.getName(), range.end.getValue());
            }
            int index = 0;
            Range currentColumn = range.next;
            for (PrimaryKeySchema pkSchema : this.meta.getPrimaryKeyList()) {
                if (index > 0) {
                    if (isRange || currentColumn == null) {
                        pkb.addPrimaryKeyColumn(pkSchema.getName(), PrimaryKeyValue.INF_MIN);
                        pkb2.addPrimaryKeyColumn(pkSchema.getName(), PrimaryKeyValue.INF_MAX);
                        isRange = true;
                    } else {
                        if (currentColumn.equal != null) {
                            pkb.addPrimaryKeyColumn(pkSchema.getName(), currentColumn.equal.getValue());
                            pkb2.addPrimaryKeyColumn(pkSchema.getName(), currentColumn.equal.getValue());
                        } else {
                            pkb.addPrimaryKeyColumn(pkSchema.getName(), currentColumn.begin.getValue());
                            pkb2.addPrimaryKeyColumn(pkSchema.getName(), currentColumn.end.getValue());
                            isRange = true;
                        }
                        currentColumn = currentColumn.next;
                    }
                }
                ++index;
            }
            PrimaryKey beginPk = pkb.build();
            if (isRange) {
                PrimaryKey endPk = pkb2.build();
                pkRange = new PkRange(beginPk, endPk);
            } else {
                pkRange = new PkRange(beginPk);
            }
            pkList.add(pkRange);
        }
        return pkList;
    }

    private boolean checkHasRange(List<Range> rangeList) {
        for (Range range : rangeList) {
            if (range.isSingleValue()) continue;
            return true;
        }
        return false;
    }

    private List<Range> mergeSubRange(List<Range> range1, List<Range> range2, PrimaryKey begin, PrimaryKey end) {
        return range1;
    }

    private List<Range> mergeTotalRange(List<Range> range1, List<Range> range2, PrimaryKey begin, PrimaryKey end) {
        range1.addAll(range2);
        return range1;
    }

    @Override
    public void initial(SyncClient client) {
        this.manager = new CatalogManager(client);
        TableCatalog catalog = this.manager.getTableCatalog(this.tableName);
        if (this.type == SplitType.KeyValue) {
            if (!this.tableName.equals(this.splitName)) {
                List<TableMeta> metas = catalog.getIndexMetaList();
                for (TableMeta tempMeta : metas) {
                    if (!tempMeta.getTableName().equals(this.splitName)) continue;
                    this.meta = tempMeta;
                    return;
                }
                throw new IllegalArgumentException("invalid split name");
            }
        } else {
            List<IndexSchema> metas = catalog.getSearchSchema();
            this.searchInfo = new SearchInfo(this.splitName, metas.get(0));
            return;
        }
        this.meta = catalog.getTableMeta();
    }

    public boolean checkIfMatchTheFilter(Filter filter) {
        if (filter.isNested()) {
            if (filter.getLogicOperator() == Filter.LogicOperator.AND) {
                for (Filter subFilter : filter.getSubFilters()) {
                    if (this.checkIfMatchTheFilter(subFilter)) continue;
                    return false;
                }
                return true;
            }
            if (filter.getLogicOperator() == Filter.LogicOperator.OR) {
                for (Filter subFilter : filter.getSubFilters()) {
                    if (!this.checkIfMatchTheFilter(subFilter)) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
        PrimaryKey pk = this.kvSplit.getLowerBound();
        if (filter.getCompareOperator() == Filter.CompareOperator.NOT_EQUAL) {
            return true;
        }
        if (Filter.CompareOperator.EQUAL == filter.getCompareOperator()) {
            if (!filter.getColumnName().equals(pk.getPrimaryKeyColumn(0).getName())) {
                return true;
            }
            try {
                return !(!this.kvSplit.getLowerBound().getPrimaryKeyColumn(0).getValue().isInfMin() && this.kvSplit.getLowerBound().getPrimaryKeyColumn(0).getValue().toColumnValue().compareTo(filter.getColumnValue()) > 0 || !this.kvSplit.getUpperBound().getPrimaryKeyColumn(0).getValue().isInfMax() && this.kvSplit.getUpperBound().getPrimaryKeyColumn(0).getValue().toColumnValue().compareTo(filter.getColumnValue()) < 0);
            }
            catch (IOException e) {
                e.printStackTrace();
                return true;
            }
        }
        if (Filter.CompareOperator.EMPTY_FILTER == filter.getCompareOperator()) {
            return true;
        }
        if (filter.getColumnName().equals(pk.getPrimaryKeyColumn(0).getName())) {
            if (filter.getCompareOperator() == Filter.CompareOperator.GREATER_THAN || filter.getCompareOperator() == Filter.CompareOperator.GREATER_EQUAL) {
                try {
                    return this.kvSplit.getUpperBound().getPrimaryKeyColumn(0).getValue().isInfMax() || this.kvSplit.getUpperBound().getPrimaryKeyColumn(0).getValue().toColumnValue().compareTo(filter.getColumnValue()) >= 0;
                }
                catch (IOException e) {
                    return true;
                }
            }
            if (filter.getCompareOperator() == Filter.CompareOperator.LESS_THAN || filter.getCompareOperator() == Filter.CompareOperator.LESS_EQUAL) {
                try {
                    return this.kvSplit.getLowerBound().getPrimaryKeyColumn(0).getValue().isInfMin() || this.kvSplit.getLowerBound().getPrimaryKeyColumn(0).getValue().toColumnValue().compareTo(filter.getColumnValue()) <= 0;
                }
                catch (IOException e) {
                    return true;
                }
            }
        }
        return true;
    }

    public SplitType getType() {
        return this.type;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public String getSplitName() {
        return this.splitName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setType(SplitType type) {
        this.type = type;
    }

    public Split getKvSplit() {
        return this.kvSplit;
    }

    public void setFilter(Filter filter) {
    }

    public String toString() {
        return "Name:" + this.tableName + ", splitname" + this.splitName + ",type:" + (Object)((Object)this.type);
    }

    public static class PkRange {
        private PrimaryKey begin;
        private PrimaryKey end;
        private PrimaryKey equal;

        public PkRange(PrimaryKey begin, PrimaryKey end) {
            this.begin = begin;
            this.end = end;
        }

        public PkRange(PrimaryKey equal) {
            this.equal = equal;
        }

        public boolean isSingleValue() {
            return this.equal != null;
        }
    }

    public static class Range {
        private PrimaryKeyColumn begin;
        private PrimaryKeyColumn end;
        private PrimaryKeyColumn equal;
        private Range next;

        public Range(Range range) {
            if (range.equal != null) {
                this.equal = range.equal;
            } else {
                this.begin = range.begin;
                this.end = range.end;
            }
            if (range.next != null) {
                this.next = range.next;
            }
        }

        public Range(PrimaryKeyColumn begin, PrimaryKeyColumn end) {
            this.begin = begin;
            this.end = end;
        }

        public Range(PrimaryKeyColumn equal) {
            this.equal = equal;
        }

        public PrimaryKeyColumn getBegin() {
            return this.begin;
        }

        public PrimaryKeyColumn getEnd() {
            return this.end;
        }

        public PrimaryKeyColumn getEqual() {
            return this.equal;
        }

        public boolean isSingleValue() {
            return this.equal != null;
        }
    }

    public static enum SplitType {
        KeyValue,
        SearchIndex;

    }
}

