/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model.search.agg;

import com.alicloud.openservices.tablestore.core.protocol.SearchAggregationBuilder;
import com.alicloud.openservices.tablestore.core.utils.ValueUtil;
import com.alicloud.openservices.tablestore.model.ColumnValue;
import com.alicloud.openservices.tablestore.model.search.agg.Aggregation;
import com.alicloud.openservices.tablestore.model.search.agg.AggregationBuilder;
import com.alicloud.openservices.tablestore.model.search.agg.AggregationType;
import com.google.protobuf.ByteString;

public class DistinctCountAggregation
implements Aggregation {
    private String aggName;
    private String fieldName;
    private ColumnValue missing;

    public DistinctCountAggregation() {
    }

    private DistinctCountAggregation(Builder builder) {
        this.aggName = builder.aggName;
        this.fieldName = builder.fieldName;
        this.missing = builder.missing;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public String getAggName() {
        return this.aggName;
    }

    @Override
    public AggregationType getAggType() {
        return AggregationType.AGG_DISTINCT_COUNT;
    }

    @Override
    public ByteString serialize() {
        return SearchAggregationBuilder.buildDistinctCountAggregation(this).toByteString();
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public ColumnValue getMissing() {
        return this.missing;
    }

    public DistinctCountAggregation setAggName(String aggName) {
        this.aggName = aggName;
        return this;
    }

    public DistinctCountAggregation setFieldName(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    public DistinctCountAggregation setMissing(ColumnValue missing) {
        this.missing = missing;
        return this;
    }

    public static final class Builder
    implements AggregationBuilder {
        private String aggName;
        private String fieldName;
        private ColumnValue missing;

        private Builder() {
        }

        public Builder aggName(String aggName) {
            this.aggName = aggName;
            return this;
        }

        public Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public Builder missing(Object missing) {
            this.missing = ValueUtil.toColumnValue(missing);
            return this;
        }

        @Override
        public DistinctCountAggregation build() {
            return new DistinctCountAggregation(this);
        }
    }
}

