/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model.search.agg;

import com.alicloud.openservices.tablestore.core.protocol.SearchAggregationBuilder;
import com.alicloud.openservices.tablestore.model.search.agg.Aggregation;
import com.alicloud.openservices.tablestore.model.search.agg.AggregationBuilder;
import com.alicloud.openservices.tablestore.model.search.agg.AggregationType;
import com.alicloud.openservices.tablestore.model.search.sort.Sort;
import com.google.protobuf.ByteString;

public class TopRowsAggregation
implements Aggregation {
    private String aggName;
    private Integer limit;
    private Sort sort;

    public TopRowsAggregation() {
    }

    private TopRowsAggregation(Builder builder) {
        this.setAggName(builder.aggName);
        this.setLimit(builder.limit);
        this.setSort(builder.sort);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public String getAggName() {
        return this.aggName;
    }

    @Override
    public AggregationType getAggType() {
        return AggregationType.AGG_TOP_ROWS;
    }

    @Override
    public ByteString serialize() {
        return SearchAggregationBuilder.buildTopRowsAggregation(this).toByteString();
    }

    public TopRowsAggregation setAggName(String aggName) {
        this.aggName = aggName;
        return this;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public TopRowsAggregation setLimit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public Sort getSort() {
        return this.sort;
    }

    public TopRowsAggregation setSort(Sort sort) {
        this.sort = sort;
        return this;
    }

    public static final class Builder
    implements AggregationBuilder {
        private String aggName;
        private Integer limit;
        private Sort sort;

        public Builder aggName(String aggName) {
            this.aggName = aggName;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder sort(Sort sort) {
            this.sort = sort;
            return this;
        }

        @Override
        public TopRowsAggregation build() {
            return new TopRowsAggregation(this);
        }
    }
}

