/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.txmsg.netty.handler;

import com.codingapi.txlcn.txmsg.dto.RpcCmd;
import com.codingapi.txlcn.txmsg.listener.HeartbeatListener;
import com.codingapi.txlcn.txmsg.netty.bean.NettyRpcCmd;
import com.codingapi.txlcn.txmsg.netty.bean.RpcContent;
import com.codingapi.txlcn.txmsg.netty.em.NettyType;
import com.codingapi.txlcn.txmsg.netty.impl.NettyContext;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@ChannelHandler.Sharable
@Component
public class RpcCmdDecoder
extends SimpleChannelInboundHandler<NettyRpcCmd> {
    private static final Logger log = LoggerFactory.getLogger(RpcCmdDecoder.class);
    @Autowired
    private HeartbeatListener heartbeatListener;

    protected void channelRead0(ChannelHandlerContext ctx, NettyRpcCmd cmd) {
        String key = cmd.getKey();
        log.debug("cmd->{}", (Object)cmd);
        if (cmd.getMsg() != null && "heartCheck".equals(cmd.getMsg().getAction())) {
            if (NettyContext.currentType().equals((Object)NettyType.client)) {
                this.heartbeatListener.onTcReceivedHeart((RpcCmd)cmd);
                ctx.writeAndFlush((Object)cmd);
                return;
            }
            this.heartbeatListener.onTmReceivedHeart((RpcCmd)cmd);
            return;
        }
        if (!StringUtils.isEmpty((Object)key)) {
            RpcContent rpcContent = cmd.loadRpcContent();
            if (rpcContent != null) {
                log.debug("got response message[Netty Handler]");
                rpcContent.setRes(cmd.getMsg());
                rpcContent.signal();
            } else {
                ctx.fireChannelRead((Object)cmd);
            }
        } else {
            ctx.fireChannelRead((Object)cmd);
        }
    }
}

