/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.data;

import com.ejlchina.data.Array;
import com.ejlchina.data.GsonMapper;
import com.ejlchina.data.Mapper;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;

public class GsonArray
implements Array {
    private final JsonArray json;

    public GsonArray(JsonArray json) {
        this.json = json;
    }

    public int size() {
        return this.json.size();
    }

    public boolean isEmpty() {
        return this.json.size() == 0;
    }

    public Mapper getMapper(int index) {
        JsonElement subJson = this.json.get(index);
        if (subJson != null && subJson.isJsonObject()) {
            return new GsonMapper(subJson.getAsJsonObject());
        }
        return null;
    }

    public Array getArray(int index) {
        JsonElement subJson = this.json.get(index);
        if (subJson != null && subJson.isJsonArray()) {
            return new GsonArray(subJson.getAsJsonArray());
        }
        return null;
    }

    public boolean getBool(int index) {
        JsonElement val = this.json.get(index);
        if (val != null && val.isJsonPrimitive()) {
            return val.getAsBoolean();
        }
        return false;
    }

    public int getInt(int index) {
        JsonElement val = this.json.get(index);
        if (val != null && val.isJsonPrimitive()) {
            return val.getAsInt();
        }
        return 0;
    }

    public long getLong(int index) {
        JsonElement val = this.json.get(index);
        if (val != null && val.isJsonPrimitive()) {
            return val.getAsLong();
        }
        return 0L;
    }

    public float getFloat(int index) {
        JsonElement val = this.json.get(index);
        if (val != null && val.isJsonPrimitive()) {
            return val.getAsFloat();
        }
        return 0.0f;
    }

    public double getDouble(int index) {
        JsonElement val = this.json.get(index);
        if (val != null && val.isJsonPrimitive()) {
            return val.getAsDouble();
        }
        return 0.0;
    }

    public String getString(int index) {
        JsonElement val = this.json.get(index);
        if (val != null && val.isJsonPrimitive()) {
            return val.getAsString();
        }
        return null;
    }

    public String toString() {
        return this.json.toString();
    }
}

