/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.data;

import com.ejlchina.data.Array;
import com.ejlchina.data.DataConvertor;
import com.ejlchina.data.GsonArray;
import com.ejlchina.data.GsonMapper;
import com.ejlchina.data.Mapper;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class GsonDataConvertor
implements DataConvertor {
    private Gson gson;

    public GsonDataConvertor() {
        this(new Gson());
    }

    public GsonDataConvertor(Gson gson) {
        this.gson = gson;
    }

    public Mapper toMapper(InputStream in, Charset charset) {
        return new GsonMapper((JsonObject)this.gson.fromJson((Reader)new InputStreamReader(in, charset), JsonObject.class));
    }

    public Array toArray(InputStream in, Charset charset) {
        return new GsonArray((JsonArray)this.gson.fromJson((Reader)new InputStreamReader(in, charset), JsonArray.class));
    }

    public byte[] serialize(Object object, Charset charset) {
        if (object instanceof GsonMapper || object instanceof GsonArray) {
            return object.toString().getBytes(charset);
        }
        return this.gson.toJson(object).getBytes(charset);
    }

    public <T> T toBean(Type type, InputStream in, Charset charset) {
        return (T)this.gson.fromJson((Reader)new InputStreamReader(in, charset), type);
    }

    public <T> List<T> toList(Class<T> type, InputStream in, Charset charset) {
        Object[] beans = (Object[])this.gson.fromJson((Reader)new InputStreamReader(in, charset), TypeToken.getArray(type).getType());
        ArrayList list = new ArrayList();
        Collections.addAll(list, beans);
        return list;
    }

    public Gson getGson() {
        return this.gson;
    }

    public void setGson(Gson gson) {
        this.gson = gson;
    }
}

