/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.data;

import com.ejlchina.data.Array;
import com.ejlchina.data.GsonArray;
import com.ejlchina.data.Mapper;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Set;

public class GsonMapper
implements Mapper {
    private final JsonObject json;

    public GsonMapper(JsonObject json) {
        this.json = json;
    }

    public int size() {
        return this.json.size();
    }

    public boolean isEmpty() {
        return this.json.size() == 0;
    }

    public Mapper getMapper(String key) {
        JsonElement subJson = this.json.get(key);
        if (subJson != null && subJson.isJsonObject()) {
            return new GsonMapper(subJson.getAsJsonObject());
        }
        return null;
    }

    public Array getArray(String key) {
        JsonElement subJson = this.json.get(key);
        if (subJson != null && subJson.isJsonArray()) {
            return new GsonArray(subJson.getAsJsonArray());
        }
        return null;
    }

    public boolean getBool(String key) {
        JsonElement val = this.json.get(key);
        if (val != null && val.isJsonPrimitive()) {
            return val.getAsBoolean();
        }
        return false;
    }

    public int getInt(String key) {
        JsonElement val = this.json.get(key);
        if (val != null && val.isJsonPrimitive()) {
            return val.getAsInt();
        }
        return 0;
    }

    public long getLong(String key) {
        JsonElement val = this.json.get(key);
        if (val != null && val.isJsonPrimitive()) {
            return val.getAsLong();
        }
        return 0L;
    }

    public float getFloat(String key) {
        JsonElement val = this.json.get(key);
        if (val != null && val.isJsonPrimitive()) {
            return val.getAsFloat();
        }
        return 0.0f;
    }

    public double getDouble(String key) {
        JsonElement val = this.json.get(key);
        if (val != null && val.isJsonPrimitive()) {
            return val.getAsDouble();
        }
        return 0.0;
    }

    public String getString(String key) {
        JsonElement val = this.json.get(key);
        if (val != null && val.isJsonPrimitive()) {
            return val.getAsString();
        }
        return null;
    }

    public boolean has(String key) {
        return this.json.has(key);
    }

    public Set<String> keySet() {
        return this.json.keySet();
    }

    public String toString() {
        return this.json.toString();
    }
}

