/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.okhttps;

import com.ejlchina.okhttps.OnCallback;
import com.ejlchina.okhttps.internal.HttpException;
import com.ejlchina.okhttps.internal.TaskExecutor;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import okhttp3.internal.Util;

public class Download {
    private File file;
    private InputStream input;
    private OnCallback<File> onSuccess;
    private OnCallback<Failure> onFailure;
    private TaskExecutor taskExecutor;
    private long doneBytes;
    private int buffSize = 0;
    private long seekBytes = 0L;
    private boolean appended;
    private volatile int status;
    private final Object lock = new Object();
    protected boolean nextOnIO = false;
    private boolean sOnIO;
    private boolean fOnIO;
    private Ctrl ctrl;

    public Download(File file, InputStream input, TaskExecutor taskExecutor, long skipBytes) {
        this.file = file;
        this.input = input;
        this.taskExecutor = taskExecutor;
        this.seekBytes = skipBytes;
        this.ctrl = new Ctrl();
    }

    public Download setBuffSize(int buffSize) {
        if (buffSize > 0) {
            this.buffSize = buffSize;
        }
        return this;
    }

    public Download setAppended() {
        this.appended = true;
        return this;
    }

    public Download setFilePointer(long seekBytes) {
        this.seekBytes = seekBytes;
        return this;
    }

    public Download nextOnIO() {
        this.nextOnIO = true;
        return this;
    }

    public Download setOnSuccess(OnCallback<File> onSuccess) {
        this.onSuccess = onSuccess;
        this.sOnIO = this.nextOnIO;
        this.nextOnIO = false;
        return this;
    }

    public Download setOnFailure(OnCallback<Failure> onFailure) {
        this.onFailure = onFailure;
        this.fOnIO = this.nextOnIO;
        this.nextOnIO = false;
        return this;
    }

    public Ctrl start() {
        if (this.buffSize == 0) {
            this.buffSize = 8192;
        }
        RandomAccessFile raFile = this.randomAccessFile();
        this.status = 1;
        this.taskExecutor.execute(() -> this.doDownload(raFile), true);
        return this.ctrl;
    }

    public Ctrl getCtrl() {
        return this.ctrl;
    }

    private RandomAccessFile randomAccessFile() {
        try {
            return new RandomAccessFile(this.file, "rw");
        }
        catch (FileNotFoundException e) {
            this.status = 4;
            Util.closeQuietly((Closeable)this.input);
            throw new HttpException("\u65e0\u6cd5\u83b7\u53d6\u6587\u4ef6[" + this.file.getAbsolutePath() + "]\u7684\u8f93\u5165\u6d41", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void doDownload(RandomAccessFile raFile) {
        try {
            if (this.appended && this.seekBytes > 0L) {
                long length = raFile.length();
                if (this.seekBytes <= length) {
                    raFile.seek(this.seekBytes);
                    this.doneBytes = this.seekBytes;
                } else {
                    raFile.seek(length);
                    this.doneBytes = length;
                }
            }
            while (this.status != -1 && this.status != 3) {
                int len;
                if (this.status != 1) continue;
                byte[] buff = new byte[this.buffSize];
                while ((len = this.input.read(buff)) != -1) {
                    raFile.write(buff, 0, len);
                    this.doneBytes += (long)len;
                    if (this.status != -1 && this.status != 2) continue;
                }
                if (len != -1) continue;
                Object object = this.lock;
                // MONITORENTER : object
                this.status = 3;
                // MONITOREXIT : object
            }
        }
        catch (IOException e) {
            Object object = this.lock;
            // MONITORENTER : object
            this.status = 4;
            // MONITOREXIT : object
            if (this.onFailure == null) throw new HttpException("\u6d41\u4f20\u8f93\u5931\u8d25", e);
            this.taskExecutor.execute(() -> this.onFailure.on(new Failure(e)), this.fOnIO);
        }
        finally {
            Util.closeQuietly((Closeable)raFile);
            Util.closeQuietly((Closeable)this.input);
            if (this.status == -1) {
                this.file.delete();
            }
        }
        if (this.status != 3) return;
        if (this.onSuccess == null) return;
        this.taskExecutor.execute(() -> this.onSuccess.on(this.file), this.sOnIO);
    }

    public class Failure {
        private IOException exception;

        Failure(IOException exception) {
            this.exception = exception;
        }

        public File getFile() {
            return Download.this.file;
        }

        public long getDoneBytes() {
            return Download.this.doneBytes;
        }

        public IOException getException() {
            return this.exception;
        }
    }

    public class Ctrl {
        public static final int STATUS__CANCELED = -1;
        public static final int STATUS__DOWNLOADING = 1;
        public static final int STATUS__PAUSED = 2;
        public static final int STATUS__DONE = 3;
        public static final int STATUS__ERROR = 4;

        public int status() {
            return Download.this.status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pause() {
            Object object = Download.this.lock;
            synchronized (object) {
                if (Download.this.status == 1) {
                    Download.this.status = 2;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resume() {
            Object object = Download.this.lock;
            synchronized (object) {
                if (Download.this.status == 2) {
                    Download.this.status = 1;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            Object object = Download.this.lock;
            synchronized (object) {
                if (Download.this.status == 2 || Download.this.status == 1) {
                    Download.this.status = -1;
                }
            }
        }
    }
}

