/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.okhttps;

import com.ejlchina.okhttps.Array;
import com.ejlchina.okhttps.Mapper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.List;

public interface MsgConvertor {
    public String mediaType();

    public Mapper toMapper(InputStream var1, Charset var2);

    public Array toArray(InputStream var1, Charset var2);

    public byte[] serialize(Object var1, Charset var2);

    public <T> T toBean(Type var1, InputStream var2, Charset var3);

    public <T> List<T> toList(Class<T> var1, InputStream var2, Charset var3);

    public static class FormConvertor
    implements MsgConvertor {
        private MsgConvertor convertor;

        public FormConvertor(MsgConvertor convertor) {
            this.convertor = convertor;
        }

        @Override
        public String mediaType() {
            return "application/x-www-form-urlencoded";
        }

        @Override
        public Mapper toMapper(InputStream in, Charset charset) {
            return this.convertor.toMapper(in, charset);
        }

        @Override
        public Array toArray(InputStream in, Charset charset) {
            return this.convertor.toArray(in, charset);
        }

        @Override
        public byte[] serialize(Object object, Charset charset) {
            byte[] data = this.convertor.serialize(object, charset);
            Mapper mapper = this.convertor.toMapper(new ByteArrayInputStream(data), charset);
            StringBuilder sb = new StringBuilder();
            for (String key : mapper.keySet()) {
                sb.append(key).append('=').append(mapper.getString(key)).append('&');
            }
            if (sb.length() > 1) {
                sb.deleteCharAt(sb.length() - 1);
            }
            return sb.toString().getBytes(charset);
        }

        @Override
        public <T> T toBean(Type type, InputStream in, Charset charset) {
            return this.convertor.toBean(type, in, charset);
        }

        @Override
        public <T> List<T> toList(Class<T> type, InputStream in, Charset charset) {
            return this.convertor.toList(type, in, charset);
        }
    }
}

