/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.okhttps.internal;

import com.ejlchina.okhttps.Cancelable;
import com.ejlchina.okhttps.HTTP;
import com.ejlchina.okhttps.HttpTask;
import com.ejlchina.okhttps.Preprocessor;
import com.ejlchina.okhttps.internal.AsyncHttpTask;
import com.ejlchina.okhttps.internal.HttpException;
import com.ejlchina.okhttps.internal.SyncHttpTask;
import com.ejlchina.okhttps.internal.TaskExecutor;
import com.ejlchina.okhttps.internal.WebSocketTask;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;

public class HttpClient
implements HTTP {
    final OkHttpClient okClient;
    final String baseUrl;
    final Map<String, String> mediaTypes;
    final TaskExecutor executor;
    final Preprocessor[] preprocessors;
    final List<TagTask> tagTasks;
    final int preprocTimeoutTimes;
    final Charset charset;
    final String bodyType;

    public HttpClient(HTTP.Builder builder) {
        this.okClient = builder.okClient();
        this.baseUrl = builder.baseUrl();
        this.mediaTypes = builder.getMediaTypes();
        this.executor = new TaskExecutor(this.okClient.dispatcher().executorService(), builder.mainExecutor(), builder.downloadListener(), builder.responseListener(), builder.exceptionListener(), builder.completeListener(), builder.msgConvertors(), builder.taskScheduler());
        this.preprocessors = builder.preprocessors();
        this.preprocTimeoutTimes = builder.preprocTimeoutTimes();
        this.charset = builder.charset();
        this.bodyType = builder.bodyType();
        this.tagTasks = new LinkedList<TagTask>();
    }

    @Override
    public AsyncHttpTask async(String url) {
        return new AsyncHttpTask(this, this.urlPath(url, false));
    }

    @Override
    public SyncHttpTask sync(String url) {
        return new SyncHttpTask(this, this.urlPath(url, false));
    }

    @Override
    public WebSocketTask webSocket(String url) {
        return new WebSocketTask(this, this.urlPath(url, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int cancel(String tag) {
        if (tag == null) {
            return 0;
        }
        int count = 0;
        List<TagTask> list = this.tagTasks;
        synchronized (list) {
            Iterator<TagTask> it = this.tagTasks.iterator();
            while (it.hasNext()) {
                TagTask tagCall = it.next();
                if (tagCall.tag.contains(tag)) {
                    if (tagCall.canceler.cancel()) {
                        ++count;
                    }
                    it.remove();
                    continue;
                }
                if (!tagCall.isExpired()) continue;
                it.remove();
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelAll() {
        this.okClient.dispatcher().cancelAll();
        List<TagTask> list = this.tagTasks;
        synchronized (list) {
            this.tagTasks.clear();
        }
    }

    @Override
    public Call request(Request request) {
        return this.okClient.newCall(request);
    }

    @Override
    public WebSocket webSocket(Request request, WebSocketListener listener) {
        return this.okClient.newWebSocket(request, listener);
    }

    public OkHttpClient okClient() {
        return this.okClient;
    }

    public int preprocTimeoutMillis() {
        return this.preprocTimeoutTimes * (this.okClient.connectTimeoutMillis() + this.okClient.writeTimeoutMillis() + this.okClient.readTimeoutMillis());
    }

    public int getTagTaskCount() {
        return this.tagTasks.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TagTask addTagTask(String tag, Cancelable canceler, HttpTask<?> task) {
        TagTask tagTask = new TagTask(tag, canceler, task);
        List<TagTask> list = this.tagTasks;
        synchronized (list) {
            this.tagTasks.add(tagTask);
        }
        return tagTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTagTask(HttpTask<?> task) {
        List<TagTask> list = this.tagTasks;
        synchronized (list) {
            Iterator<TagTask> it = this.tagTasks.iterator();
            while (it.hasNext()) {
                TagTask tagCall = it.next();
                if (tagCall.task == task) {
                    it.remove();
                    break;
                }
                if (!tagCall.isExpired()) continue;
                it.remove();
            }
        }
    }

    public MediaType mediaType(String type) {
        String mediaType = this.mediaTypes.get(type);
        if (mediaType != null) {
            return MediaType.parse((String)mediaType);
        }
        return MediaType.parse((String)"application/octet-stream");
    }

    @Override
    public TaskExecutor executor() {
        return this.executor;
    }

    public void preprocess(HttpTask<?> httpTask, Runnable request, boolean skipPreproc, boolean skipSerialPreproc) {
        int index;
        if (this.preprocessors.length == 0 || skipPreproc) {
            request.run();
            return;
        }
        if (skipSerialPreproc) {
            for (index = 0; index < this.preprocessors.length && this.preprocessors[index] instanceof SerialPreprocessor; ++index) {
            }
        }
        if (index < this.preprocessors.length) {
            RealPreChain chain = new RealPreChain(this.preprocessors, httpTask, request, index + 1, skipSerialPreproc);
            this.preprocessors[index].doProcess(chain);
        } else {
            request.run();
        }
    }

    @Override
    public HTTP.Builder newBuilder() {
        return new HTTP.Builder(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String urlPath(String urlPath, boolean websocket) {
        String fullUrl;
        if (urlPath == null) {
            if (this.baseUrl == null) throw new HttpException("\u5728\u8bbe\u7f6e BaseUrl \u4e4b\u524d\uff0c\u60a8\u5fc5\u987b\u6307\u5b9a\u5177\u4f53\u8def\u5f84\u624d\u80fd\u53d1\u8d77\u8bf7\u6c42\uff01");
            fullUrl = this.baseUrl;
        } else {
            boolean isFullPath;
            boolean bl = isFullPath = urlPath.startsWith("https://") || urlPath.startsWith("http://") || urlPath.startsWith("wss://") || urlPath.startsWith("ws://");
            if (isFullPath) {
                fullUrl = urlPath;
            } else {
                if (this.baseUrl == null) throw new HttpException("\u5728\u8bbe\u7f6e BaseUrl \u4e4b\u524d\uff0c\u60a8\u5fc5\u987b\u4f7f\u7528\u5168\u8def\u5f84URL\u53d1\u8d77\u8bf7\u6c42\uff0c\u5f53\u524dURL\u4e3a\uff1a" + urlPath);
                fullUrl = this.baseUrl + urlPath;
            }
        }
        if (websocket && fullUrl.startsWith("http")) {
            return fullUrl.replaceFirst("http", "ws");
        }
        if (websocket || !fullUrl.startsWith("ws")) return fullUrl;
        return fullUrl.replaceFirst("ws", "http");
    }

    public String baseUrl() {
        return this.baseUrl;
    }

    public Map<String, String> mediaTypes() {
        return this.mediaTypes;
    }

    public Preprocessor[] preprocessors() {
        return this.preprocessors;
    }

    public List<TagTask> tagTasks() {
        return this.tagTasks;
    }

    public int preprocTimeoutTimes() {
        return this.preprocTimeoutTimes;
    }

    public Charset charset() {
        return this.charset;
    }

    public String bodyType() {
        return this.bodyType;
    }

    class RealPreChain
    implements Preprocessor.PreChain {
        private int index;
        private Preprocessor[] preprocessors;
        private HttpTask<?> httpTask;
        private Runnable request;
        private boolean noSerialPreprocess;

        public RealPreChain(Preprocessor[] preprocessors, HttpTask<?> httpTask, Runnable request, int index, boolean noSerialPreprocess) {
            this.index = index;
            this.preprocessors = preprocessors;
            this.httpTask = httpTask;
            this.request = request;
            this.noSerialPreprocess = noSerialPreprocess;
        }

        @Override
        public HttpTask<?> getTask() {
            return this.httpTask;
        }

        @Override
        public HTTP getHttp() {
            return HttpClient.this;
        }

        @Override
        public void proceed() {
            if (this.noSerialPreprocess) {
                while (this.index < this.preprocessors.length && this.preprocessors[this.index] instanceof SerialPreprocessor) {
                    ++this.index;
                }
            } else {
                Preprocessor last = this.preprocessors[this.index - 1];
                if (last instanceof SerialPreprocessor) {
                    ((SerialPreprocessor)last).afterProcess();
                }
            }
            if (this.index < this.preprocessors.length) {
                this.preprocessors[this.index++].doProcess(this);
            } else {
                this.request.run();
            }
        }
    }

    public static class SerialPreprocessor
    implements Preprocessor {
        private Preprocessor preprocessor;
        private Queue<Preprocessor.PreChain> pendings;
        private boolean running = false;

        public SerialPreprocessor(Preprocessor preprocessor) {
            this.preprocessor = preprocessor;
            this.pendings = new LinkedList<Preprocessor.PreChain>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doProcess(Preprocessor.PreChain chain) {
            boolean should = true;
            SerialPreprocessor serialPreprocessor = this;
            synchronized (serialPreprocessor) {
                if (this.running) {
                    this.pendings.add(chain);
                    should = false;
                } else {
                    this.running = true;
                }
            }
            if (should) {
                this.preprocessor.doProcess(chain);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterProcess() {
            Preprocessor.PreChain chain = null;
            SerialPreprocessor serialPreprocessor = this;
            synchronized (serialPreprocessor) {
                if (this.pendings.size() > 0) {
                    chain = this.pendings.poll();
                } else {
                    this.running = false;
                }
            }
            if (chain != null) {
                this.preprocessor.doProcess(chain);
            }
        }
    }

    public class TagTask {
        String tag;
        Cancelable canceler;
        HttpTask<?> task;
        long createAt;

        TagTask(String tag, Cancelable canceler, HttpTask<?> task) {
            this.tag = tag;
            this.canceler = canceler;
            this.task = task;
            this.createAt = System.nanoTime();
        }

        boolean isExpired() {
            return System.nanoTime() - this.createAt > (long)(1000000 * HttpClient.this.preprocTimeoutMillis());
        }

        public void setTag(String tag) {
            this.tag = tag;
        }
    }
}

