/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.okhttps.internal;

import com.ejlchina.okhttps.DownListener;
import com.ejlchina.okhttps.Download;
import com.ejlchina.okhttps.HttpResult;
import com.ejlchina.okhttps.HttpTask;
import com.ejlchina.okhttps.MsgConvertor;
import com.ejlchina.okhttps.OnCallback;
import com.ejlchina.okhttps.Scheduler;
import com.ejlchina.okhttps.TaskListener;
import com.ejlchina.okhttps.internal.HttpException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import okhttp3.internal.Util;

public final class TaskExecutor {
    private Executor ioExecutor;
    private Executor mainExecutor;
    private Scheduler taskScheduler;
    private DownListener downloadListener;
    private TaskListener<HttpResult> responseListener;
    private TaskListener<IOException> exceptionListener;
    private TaskListener<HttpResult.State> completeListener;
    private MsgConvertor[] msgConvertors;
    private ScheduledExecutorService scheduledService;

    public TaskExecutor(Executor ioExecutor, Executor mainExecutor, DownListener downloadListener, TaskListener<HttpResult> responseListener, TaskListener<IOException> exceptionListener, TaskListener<HttpResult.State> completeListener, MsgConvertor[] msgConvertors, Scheduler taskScheduler) {
        this.ioExecutor = ioExecutor;
        this.mainExecutor = mainExecutor;
        this.downloadListener = downloadListener;
        this.responseListener = responseListener;
        this.exceptionListener = exceptionListener;
        this.completeListener = completeListener;
        this.msgConvertors = msgConvertors;
        this.taskScheduler = taskScheduler;
    }

    public Executor getExecutor(boolean onIo) {
        if (onIo || this.mainExecutor == null) {
            return this.ioExecutor;
        }
        return this.mainExecutor;
    }

    public Download download(HttpTask<?> httpTask, File file, InputStream input, long skipBytes) {
        Download download = new Download(file, input, this, skipBytes);
        if (httpTask != null && this.downloadListener != null) {
            this.downloadListener.listen(httpTask, download);
        }
        return download;
    }

    public void execute(Runnable command, boolean onIo) {
        Executor executor = this.ioExecutor;
        if (this.mainExecutor != null && !onIo) {
            executor = this.mainExecutor;
        }
        executor.execute(command);
    }

    public void executeOnResponse(HttpTask<?> task, OnCallback<HttpResult> onResponse, HttpResult result, boolean onIo) {
        if (this.responseListener != null) {
            if (this.responseListener.listen(task, result) && onResponse != null) {
                this.execute(() -> onResponse.on(result), onIo);
            }
        } else if (onResponse != null) {
            this.execute(() -> onResponse.on(result), onIo);
        }
    }

    public boolean executeOnException(HttpTask<?> task, OnCallback<IOException> onException, IOException error, boolean onIo) {
        if (this.exceptionListener != null) {
            if (this.exceptionListener.listen(task, error) && onException != null) {
                this.execute(() -> onException.on(error), onIo);
            }
        } else if (onException != null) {
            this.execute(() -> onException.on(error), onIo);
        } else {
            return false;
        }
        return true;
    }

    public void executeOnComplete(HttpTask<?> task, OnCallback<HttpResult.State> onComplete, HttpResult.State state, boolean onIo) {
        if (this.completeListener != null) {
            if (this.completeListener.listen(task, state) && onComplete != null) {
                this.execute(() -> onComplete.on(state), onIo);
            }
        } else if (onComplete != null) {
            this.execute(() -> onComplete.on(state), onIo);
        }
    }

    public <V> V doMsgConvert(ConvertFunc<V> callable) {
        return (V)this.doMsgConvert(null, callable).data;
    }

    public <V> Data<V> doMsgConvert(String type, ConvertFunc<V> callable) {
        Exception cause = null;
        for (int i = this.msgConvertors.length - 1; i >= 0; --i) {
            MsgConvertor convertor = this.msgConvertors[i];
            String mediaType = convertor.mediaType();
            if (type != null && (mediaType == null || !mediaType.contains(type))) continue;
            if (callable == null && mediaType != null) {
                return new Data<Object>(null, mediaType);
            }
            try {
                assert (callable != null);
                return new Data<V>(callable.apply(convertor), mediaType);
            }
            catch (Exception e) {
                if (cause != null) {
                    this.initRootCause(e, cause);
                }
                cause = e;
            }
        }
        if (callable == null) {
            return new Data<Object>(null, "application/x-www-form-urlencoded");
        }
        if (cause != null) {
            throw new HttpException("\u8f6c\u6362\u5931\u8d25", cause);
        }
        throw new HttpException("\u6ca1\u6709\u5339\u914d[" + type + "]\u7c7b\u578b\u7684\u8f6c\u6362\u5668\uff01");
    }

    private void initRootCause(Throwable throwable, Throwable cause) {
        Throwable lastCause = throwable.getCause();
        if (lastCause != null) {
            this.initRootCause(lastCause, cause);
        } else {
            throwable.initCause(cause);
        }
    }

    public synchronized Scheduler requireScheduler() {
        if (this.taskScheduler == null) {
            this.scheduledService = new ScheduledThreadPoolExecutor(1, Util.threadFactory((String)"OkHttps-Scheduler", (boolean)false));
            this.taskScheduler = this.scheduledService::schedule;
        }
        return this.taskScheduler;
    }

    public void shutdown() {
        if (this.ioExecutor != null && this.ioExecutor instanceof ExecutorService) {
            ((ExecutorService)this.ioExecutor).shutdown();
        }
        if (this.mainExecutor != null && this.mainExecutor instanceof ExecutorService) {
            ((ExecutorService)this.mainExecutor).shutdown();
        }
        if (this.scheduledService != null) {
            this.scheduledService.shutdown();
        }
    }

    public Executor getIoExecutor() {
        return this.ioExecutor;
    }

    public Executor getMainExecutor() {
        return this.mainExecutor;
    }

    public DownListener getDownloadListener() {
        return this.downloadListener;
    }

    public TaskListener<HttpResult> getResponseListener() {
        return this.responseListener;
    }

    public TaskListener<IOException> getExceptionListener() {
        return this.exceptionListener;
    }

    public TaskListener<HttpResult.State> getCompleteListener() {
        return this.completeListener;
    }

    public MsgConvertor[] getMsgConvertors() {
        return this.msgConvertors;
    }

    public Scheduler getTaskScheduler() {
        return this.taskScheduler;
    }

    public static class Data<T> {
        public T data;
        public String mediaType;

        public Data(T data, String mediaType) {
            this.data = data;
            this.mediaType = mediaType;
        }
    }

    public static interface ConvertFunc<T> {
        public T apply(MsgConvertor var1);
    }
}

