/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.okhttps;

import com.ejlchina.okhttps.DownListener;
import com.ejlchina.okhttps.HttpResult;
import com.ejlchina.okhttps.MsgConvertor;
import com.ejlchina.okhttps.Platform;
import com.ejlchina.okhttps.Preprocessor;
import com.ejlchina.okhttps.Scheduler;
import com.ejlchina.okhttps.TaskListener;
import com.ejlchina.okhttps.internal.AsyncHttpTask;
import com.ejlchina.okhttps.internal.CopyInterceptor;
import com.ejlchina.okhttps.internal.HttpClient;
import com.ejlchina.okhttps.internal.SyncHttpTask;
import com.ejlchina.okhttps.internal.TaskExecutor;
import com.ejlchina.okhttps.internal.WebSocketTask;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;

public interface HTTP {
    public static final String GET = "GET";
    public static final String HEAD = "HEAD";
    public static final String POST = "POST";
    public static final String PUT = "PUT";
    public static final String PATCH = "PATCH";
    public static final String DELETE = "DELETE";

    public SyncHttpTask sync(String var1);

    public AsyncHttpTask async(String var1);

    public WebSocketTask webSocket(String var1);

    public int cancel(String var1);

    public void cancelAll();

    public Call request(Request var1);

    public WebSocket webSocket(Request var1, WebSocketListener var2);

    public TaskExecutor executor();

    public Builder newBuilder();

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private OkHttpClient okClient;
        private String baseUrl;
        private Map<String, String> mediaTypes;
        private List<String> contentTypes;
        private OkConfig config;
        private Executor mainExecutor;
        private Scheduler taskScheduler;
        private List<Preprocessor> preprocessors;
        private DownListener downloadListener;
        private TaskListener<HttpResult> responseListener;
        private TaskListener<IOException> exceptionListener;
        private TaskListener<HttpResult.State> completeListener;
        private List<MsgConvertor> msgConvertors;
        private int preprocTimeoutTimes = 10;
        private Charset charset = StandardCharsets.UTF_8;
        private String bodyType = "form";

        public Builder() {
            this.mediaTypes = new HashMap<String, String>();
            this.mediaTypes.put("*", "application/octet-stream");
            this.mediaTypes.put("png", "image/png");
            this.mediaTypes.put("jpg", "image/jpeg");
            this.mediaTypes.put("jpeg", "image/jpeg");
            this.mediaTypes.put("wav", "audio/wav");
            this.mediaTypes.put("mp3", "audio/mp3");
            this.mediaTypes.put("mp4", "video/mpeg4");
            this.mediaTypes.put("txt", "text/plain");
            this.mediaTypes.put("xls", "application/x-xls");
            this.mediaTypes.put("xml", "text/xml");
            this.mediaTypes.put("apk", "application/vnd.android.package-archive");
            this.mediaTypes.put("doc", "application/msword");
            this.mediaTypes.put("pdf", "application/pdf");
            this.mediaTypes.put("html", "text/html");
            this.contentTypes = new ArrayList<String>();
            this.contentTypes.add("application/x-www-form-urlencoded");
            this.contentTypes.add("application/json");
            this.contentTypes.add("application/xml");
            this.contentTypes.add("application/x-protobuf");
            this.preprocessors = new ArrayList<Preprocessor>();
            this.msgConvertors = new ArrayList<MsgConvertor>();
        }

        public Builder(HttpClient hc) {
            this.okClient = hc.okClient();
            this.baseUrl = hc.baseUrl();
            this.mediaTypes = hc.mediaTypes();
            this.preprocessors = new ArrayList<Preprocessor>();
            Collections.addAll(this.preprocessors, hc.preprocessors());
            TaskExecutor executor = hc.executor();
            this.contentTypes = new ArrayList<String>();
            Collections.addAll(this.contentTypes, executor.getContentTypes());
            this.mainExecutor = executor.getMainExecutor();
            this.taskScheduler = executor.getTaskScheduler();
            this.downloadListener = executor.getDownloadListener();
            this.responseListener = executor.getResponseListener();
            this.exceptionListener = executor.getExceptionListener();
            this.completeListener = executor.getCompleteListener();
            this.msgConvertors = new ArrayList<MsgConvertor>();
            Collections.addAll(this.msgConvertors, executor.getMsgConvertors());
            this.preprocTimeoutTimes = hc.preprocTimeoutTimes();
            this.bodyType = hc.bodyType();
            this.charset = hc.charset();
        }

        public Builder config(OkConfig config) {
            this.config = config;
            return this;
        }

        public Builder baseUrl(String baseUrl) {
            if (baseUrl != null) {
                this.baseUrl = baseUrl.trim();
            }
            return this;
        }

        public Builder mediaTypes(Map<String, String> mediaTypes) {
            if (mediaTypes != null) {
                this.mediaTypes.putAll(mediaTypes);
            }
            return this;
        }

        public Builder mediaTypes(String key, String value) {
            if (key != null && value != null) {
                this.mediaTypes.put(key, value);
            }
            return this;
        }

        public Builder contentTypes(List<String> contentTypes) {
            if (contentTypes != null) {
                this.contentTypes.addAll(contentTypes);
            }
            return this;
        }

        public Builder contentTypes(String contentType) {
            if (contentType != null) {
                this.contentTypes.add(contentType);
            }
            return this;
        }

        public Builder callbackExecutor(Executor executor) {
            this.mainExecutor = executor;
            return this;
        }

        public Builder taskScheduler(Scheduler scheduler) {
            this.taskScheduler = scheduler;
            return this;
        }

        public Builder addPreprocessor(Preprocessor preprocessor) {
            if (preprocessor != null) {
                this.preprocessors.add(preprocessor);
            }
            return this;
        }

        public Builder addSerialPreprocessor(Preprocessor preprocessor) {
            if (preprocessor != null) {
                this.preprocessors.add(new HttpClient.SerialPreprocessor(preprocessor));
            }
            return this;
        }

        public Builder clearPreprocessors() {
            this.preprocessors.clear();
            return this;
        }

        public Builder preprocTimeoutTimes(int times) {
            if (times > 0) {
                this.preprocTimeoutTimes = times;
            }
            return this;
        }

        public Builder responseListener(TaskListener<HttpResult> listener) {
            this.responseListener = listener;
            return this;
        }

        public Builder exceptionListener(TaskListener<IOException> listener) {
            this.exceptionListener = listener;
            return this;
        }

        public Builder completeListener(TaskListener<HttpResult.State> listener) {
            this.completeListener = listener;
            return this;
        }

        public Builder downloadListener(DownListener listener) {
            this.downloadListener = listener;
            return this;
        }

        public Builder addMsgConvertor(MsgConvertor msgConvertor) {
            if (msgConvertor != null) {
                this.msgConvertors.add(msgConvertor);
            }
            return this;
        }

        public Builder clearMsgConvertors() {
            this.msgConvertors.clear();
            return this;
        }

        public Builder charset(Charset charset) {
            if (charset != null) {
                this.charset = charset;
            }
            return this;
        }

        public Builder bodyType(String bodyType) {
            if (bodyType != null) {
                this.bodyType = bodyType.toLowerCase();
            }
            return this;
        }

        public HTTP build() {
            if (this.config != null || this.okClient == null) {
                OkHttpClient.Builder builder = this.okClient != null ? this.okClient.newBuilder() : new OkHttpClient.Builder();
                if (this.config != null) {
                    this.config.config(builder);
                }
                if (this.needCopyInterceptor(builder.interceptors())) {
                    builder.addInterceptor((Interceptor)new CopyInterceptor());
                }
                this.okClient = builder.build();
            } else if (this.needCopyInterceptor(this.okClient.interceptors())) {
                this.okClient = this.okClient.newBuilder().addInterceptor((Interceptor)new CopyInterceptor()).build();
            }
            return new HttpClient(this);
        }

        private boolean needCopyInterceptor(List<Interceptor> list) {
            return this.mainExecutor != null && Platform.ANDROID_SDK_INT > 24 && CopyInterceptor.notIn(list);
        }

        public OkHttpClient okClient() {
            return this.okClient;
        }

        public String baseUrl() {
            return this.baseUrl;
        }

        public Map<String, String> getMediaTypes() {
            return this.mediaTypes;
        }

        public Executor mainExecutor() {
            return this.mainExecutor;
        }

        public Preprocessor[] preprocessors() {
            return this.preprocessors.toArray(new Preprocessor[0]);
        }

        public DownListener downloadListener() {
            return this.downloadListener;
        }

        public TaskListener<HttpResult> responseListener() {
            return this.responseListener;
        }

        public TaskListener<IOException> exceptionListener() {
            return this.exceptionListener;
        }

        public TaskListener<HttpResult.State> completeListener() {
            return this.completeListener;
        }

        public MsgConvertor[] msgConvertors() {
            return this.msgConvertors.toArray(new MsgConvertor[0]);
        }

        public Scheduler taskScheduler() {
            return this.taskScheduler;
        }

        public String[] contentTypes() {
            return this.contentTypes.toArray(new String[0]);
        }

        public int preprocTimeoutTimes() {
            return this.preprocTimeoutTimes;
        }

        public Charset charset() {
            return this.charset;
        }

        public String bodyType() {
            return this.bodyType;
        }
    }

    public static interface OkConfig {
        public void config(OkHttpClient.Builder var1);
    }
}

