/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.okhttps.internal;

import com.ejlchina.okhttps.OnCallback;
import com.ejlchina.okhttps.Process;
import com.ejlchina.okhttps.internal.RealProcess;
import java.io.IOException;
import java.util.concurrent.Executor;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.ForwardingSink;
import okio.Okio;
import okio.Sink;

public class ProcessRequestBody
extends RequestBody {
    private final RequestBody requestBody;
    private final OnCallback<Process> onProcess;
    private final Executor callbackExecutor;
    private final RealProcess process;
    private final long stepBytes;
    private boolean doneCalled = false;
    private long step = 0L;
    private BufferedSink bufferedSink;

    public ProcessRequestBody(RequestBody requestBody, OnCallback<Process> onProcess, Executor callbackExecutor, long contentLength, long stepBytes) {
        this.requestBody = requestBody;
        this.onProcess = onProcess;
        this.callbackExecutor = callbackExecutor;
        this.stepBytes = stepBytes;
        this.process = new RealProcess(contentLength, 0L);
    }

    public long contentLength() {
        return this.process.getTotalBytes();
    }

    public boolean isDuplex() {
        return this.requestBody.isDuplex();
    }

    public boolean isOneShot() {
        return this.requestBody.isOneShot();
    }

    public MediaType contentType() {
        return this.requestBody.contentType();
    }

    public void writeTo(BufferedSink sink) throws IOException {
        if (this.bufferedSink == null) {
            this.bufferedSink = Okio.buffer((Sink)new ForwardingSink((Sink)sink){

                public void write(Buffer source, long byteCount) throws IOException {
                    super.write(source, byteCount);
                    ProcessRequestBody.this.process.addDoneBytes(byteCount);
                    if (ProcessRequestBody.this.process.notDoneOrReached(ProcessRequestBody.this.step * ProcessRequestBody.this.stepBytes)) {
                        return;
                    }
                    if (ProcessRequestBody.this.process.isDone()) {
                        if (ProcessRequestBody.this.doneCalled) {
                            return;
                        }
                        ProcessRequestBody.this.doneCalled = true;
                    }
                    ProcessRequestBody.this.step++;
                    ProcessRequestBody.this.callbackExecutor.execute(() -> ProcessRequestBody.this.onProcess.on(ProcessRequestBody.this.process));
                }
            });
        }
        this.requestBody.writeTo(this.bufferedSink);
        this.bufferedSink.flush();
    }
}

