/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.okhttps.internal;

import com.ejlchina.okhttps.OnCallback;
import com.ejlchina.okhttps.Process;
import com.ejlchina.okhttps.internal.FixedRequestBody;
import com.ejlchina.okhttps.internal.RealProcess;
import java.io.IOException;
import java.util.concurrent.Executor;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.ForwardingSink;
import okio.Okio;
import okio.Sink;

public class ProcessRequestBody
extends FixedRequestBody {
    private final OnCallback<Process> onProcess;
    private final Executor callbackExecutor;
    private final RealProcess process;
    private final long stepBytes;

    public ProcessRequestBody(RequestBody requestBody, OnCallback<Process> onProcess, Executor callbackExecutor, long contentLength, long stepBytes) {
        super(requestBody);
        this.onProcess = onProcess;
        this.callbackExecutor = callbackExecutor;
        this.stepBytes = stepBytes;
        this.process = new RealProcess(contentLength, 0L);
    }

    @Override
    public void writeTo(BufferedSink sink) throws IOException {
        BufferedSink buffer = Okio.buffer((Sink)new ProcessableSink((Sink)sink));
        super.writeTo(buffer);
        buffer.flush();
    }

    class ProcessableSink
    extends ForwardingSink {
        private long step;
        private boolean doneCalled;

        public ProcessableSink(Sink delegate) {
            super(delegate);
            this.step = 0L;
            this.doneCalled = false;
        }

        public void write(Buffer source, long byteCount) throws IOException {
            long count;
            for (long written = 0L; written < byteCount; written += count) {
                count = Math.min(ProcessRequestBody.this.stepBytes, byteCount - written);
                super.write(source, count);
                this.updateProcess(count);
            }
        }

        private void updateProcess(long count) {
            ProcessRequestBody.this.process.addDoneBytes(count);
            if (ProcessRequestBody.this.process.isUndoneAndUnreached(this.step * ProcessRequestBody.this.stepBytes)) {
                return;
            }
            if (ProcessRequestBody.this.process.isDone()) {
                if (this.doneCalled) {
                    return;
                }
                this.doneCalled = true;
            }
            this.step = (ProcessRequestBody.this.process.getDoneBytes() - 1L) / ProcessRequestBody.this.stepBytes + 1L;
            Process p = ProcessRequestBody.this.process.newProcess();
            ProcessRequestBody.this.callbackExecutor.execute(() -> ProcessRequestBody.this.onProcess.on(p));
        }
    }
}

