/*
 * Decompiled with CFR 0.152.
 */
package com.envisioniot.enos.event_service.vo.condition;

import com.envisioniot.enos.event_service.vo.condition.AndCondition;
import com.envisioniot.enos.event_service.vo.condition.ConditionType;
import com.envisioniot.enos.event_service.vo.condition.NotCondition;
import com.envisioniot.enos.event_service.vo.condition.OrCondition;
import com.envisioniot.enos.event_service.vo.condition.RangeCondition;
import com.envisioniot.enos.event_service.vo.condition.RelativeCondition;
import com.envisioniot.enos.event_service.vo.condition.SimpleCondition;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class AbstractCondition
implements Serializable {
    private static final long serialVersionUID = -1552975627546257175L;

    public abstract ConditionType getConditionType();

    public Set<String> getRelativeFields() {
        if (this instanceof SimpleCondition) {
            return null;
        }
        if (this instanceof RelativeCondition) {
            String relativeField = ((RelativeCondition)this).getAnotherName();
            HashSet<String> relativeSet = new HashSet<String>();
            if (relativeField != null) {
                relativeSet.add(relativeField);
            }
            return relativeSet;
        }
        if (this instanceof RangeCondition) {
            return null;
        }
        if (this instanceof NotCondition) {
            AbstractCondition oppositeCondition = ((NotCondition)this).getCondition();
            return oppositeCondition.getRelativeFields();
        }
        if (this instanceof OrCondition || this instanceof AndCondition) {
            List<AbstractCondition> conditionList = this instanceof OrCondition ? ((OrCondition)this).getConditionList() : ((AndCondition)this).getConditionList();
            HashSet<String> relativeSet = new HashSet<String>();
            for (AbstractCondition condition : conditionList) {
                Set<String> tmpSet = condition.getRelativeFields();
                if (tmpSet == null || tmpSet.size() <= 0) continue;
                relativeSet.addAll(tmpSet);
            }
            return relativeSet;
        }
        return null;
    }

    public String detectPointId() {
        String pointId = this.detectRawPointId();
        if (pointId == null) {
            return null;
        }
        return pointId.replaceAll("/.*", "");
    }

    private String detectRawPointId() {
        if (this instanceof SimpleCondition) {
            return ((SimpleCondition)this).getName();
        }
        if (this instanceof RelativeCondition) {
            return ((RelativeCondition)this).getName();
        }
        if (this instanceof RangeCondition) {
            return ((RangeCondition)this).getName();
        }
        if (this instanceof NotCondition) {
            AbstractCondition oppositeCondition = ((NotCondition)this).getCondition();
            if (oppositeCondition != null) {
                return oppositeCondition.detectRawPointId();
            }
            return null;
        }
        if (this instanceof OrCondition) {
            List<AbstractCondition> conditionList = ((OrCondition)this).getConditionList();
            return this.detectPointIdFromConditionList(conditionList);
        }
        if (this instanceof AndCondition) {
            List<AbstractCondition> conditionList = ((AndCondition)this).getConditionList();
            return this.detectPointIdFromConditionList(conditionList);
        }
        return null;
    }

    private String detectPointIdFromConditionList(List<AbstractCondition> conditionList) {
        if (conditionList == null || conditionList.size() == 0) {
            return null;
        }
        for (AbstractCondition condition : conditionList) {
            String pointId = condition.detectRawPointId();
            if (pointId == null) continue;
            return pointId;
        }
        return null;
    }
}

